@extends('organization::panel.organization.layouts.master')
@section('title', @$data['title'])
@section('content')
<!-- Courses -->
<section>
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap mb-10 pb-20 gap-15">
                <h2 class="title font-600">{{ $data['title'] }}</h2>
                <div class="right d-flex flex-wrap justify-content-between">
                    <!-- Search Box -->

                    <!-- /End -->
                </div>
            </div>
        </div>

        <!-- Search -->
    </div>

    <div class="row">
        <div class="col-xl-12">
            <div class="card mt-4">
                <div class="card-body">
                    <h3>{{ __('Issue Support') }}</h3>
                    <form action="{{ route('organization.storeFeedback') }}" method="POST">
                        @csrf
                        <div class="form-group mt-4">
                            <label for="feedback">{{ __('Your Issue') }}</label>
                            <textarea name="issue" id="issue" class="form-control" rows="10" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary mt-2">{{ __('Submit Issue') }}</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Course -->
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-3 row-cols-xl-3 row-cols-xxl-5 g-24 mt-0 p-0 ">



    </div>
</section>


@endsection
@section('scripts')
<script>
    function copyReferralLink() {
        var copyText = document.querySelector('.referral-link input');
        copyText.select();
        document.execCommand('copy');
        alert('{{ __("Link copied to clipboard!") }}');
    }
</script>
@endsection