@extends('panel.instructor.layouts.master')
@section('title')
{{ @$data['title'] }}
@endsection
@section('content')
<div class="page-content">

    {{-- breadecrumb Area S t a r t --}}
    @include('backend.ui-components.breadcrumb', [
    'title' => @$data['title'],
    'routes' => [
    route('dashboard') => ___('common.Dashboard'),
    route('slider.index') => ___('slider.Ads'),
    '#' => @$data['title'],
    ],
    'buttons' => 0,
    ])
    {{-- breadecrumb Area E n d --}}

    <!--  category create start -->
    <div class="card ot-card">

        <div class="card-body">
            <form action="{{ route('organization.slot.store') }}" enctype="multipart/form-data" method="post">
                @csrf
                {{-- Style Two --}}
                {{-- Day-wise Slots --}}
                <h3>Set Availability</h3>



                @foreach(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] as $day)
                @php
                $daySlots = $data['slots']->where('day', $day);
                $startTime = $daySlots->min('start_time');
                $endTime = $daySlots->max('end_time');
                @endphp
                <div class="row mb-3">
                    <div class="col-lg-4">
                        <label for="start_time_{{ strtolower($day) }}" class="form-label">{{ $day }} Start Time</label>
                        <input type="time" name="start_time_{{ strtolower($day) }}" id="start_time_{{ strtolower($day) }}"
                            class="form-control @error('start_time_' . strtolower($day)) is-invalid @enderror"
                            value="{{ old('start_time_' . strtolower($day), $startTime) }}">
                        @error('start_time_' . strtolower($day))
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>
                    <div class="col-lg-4">
                        <label for="end_time_{{ strtolower($day) }}" class="form-label">{{ $day }} End Time</label>
                        <input type="time" name="end_time_{{ strtolower($day) }}" id="end_time_{{ strtolower($day) }}"
                            class="form-control @error('end_time_' . strtolower($day)) is-invalid @enderror"
                            value="{{ old('end_time_' . strtolower($day), $endTime) }}">
                        @error('end_time_' . strtolower($day))
                        <div class="invalid-feedback">
                            {{ $message }}
                        </div>
                        @enderror
                    </div>
                </div>
                @endforeach

                <button type="submit" class="btn btn-primary">Save Availability</button>
            </form>

            <h3>Generated Slots</h3>
            @foreach(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'] as $day)
            <h4>{{ $day }}</h4>
            <div class="row mb-3">
                @foreach(@$data['slots']->where('day', $day) as $slot)
                <div class="col-md-4">
                    <p>{{ $slot->start_time }} - {{ $slot->end_time }}</p>
                </div>
                @endforeach
            </div>
            @endforeach
        </div>
    </div>

    <!--  category create end -->
</div>
@endsection