<?php

namespace Modules\Slot\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Contracts\Support\Renderable;
use Modules\Slot\Interfaces\SlotInterface;
use Modules\Slot\Http\Requests\CreateSlotRequest;
use Modules\Slot\Http\Requests\UpdateSlotRequest;


class SlotController extends Controller
{
    // constructor injection
    protected $slot;

    public function __construct(SlotInterface $slot)
    {
        $this->slot         = $slot;
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index(Request $request)
    {

        try {

            $data['tableHeader']    = $this->slot->tableHeader(); // table header
            $data['slots']        = $this->slot->getAll($request); // data
            $data['title']          = ___('slot.slot'); // title


            if ($data['slots']) {
                return view('slot::slot.index', compact('data')); // view
            }

            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));

        } catch (\Throwable $th) {

            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

        try {
            $data['title']              =   ___('slot.Create slot'); // title
            $data['button']             =   ___('common.create'); // button
            return view('slot::slot.create', compact('data'));
        } catch (\Throwable $th) {

            return redirect()->route('slot.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */

    public function store(CreateSlotRequest $request)
    {


        try {
            $result = $this->slot->store($request);
            if ($result->original['result']) {
                return redirect()->route('slot.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('slot.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {

            return redirect()->route('slot.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('slot::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        try {
            $data['title']              = ___('slot.Edit slot'); // title
            $data['button']             = ___('common.update'); // button
            $data['slot']               = $this->slot->model()->find($id);

            return view('slot::slot.edit', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('slot.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(UpdateSlotRequest $request, $id)
    {
        try {
            $result = $this->slot->update($request, $id);
            if ($result->original['result']) {
                return redirect()->route('slot.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('slot.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('slot.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try {
            $result = $this->slot->destroy($id);
            if ($result->original['result']) {
                return redirect()->route('slot.index')->with('success', $result->original['message']);
            } else {
                return redirect()->route('slot.index')->with('danger', $result->original['message']);
            }
        } catch (\Throwable $th) {
            return redirect()->route('slot.index')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
}
