<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::prefix('admin')->middleware(['auth.routes'])->group(function() {

    // Start Slot  Routes
    Route::controller(SlotController::class)->prefix('slot')->group(function() {
        Route::get('/',                 'index')->name('slot.index')->middleware('PermissionCheck:slot_read');
        Route::get('/create',           'create')->name('slot.create')->middleware('PermissionCheck:slot_create');
        Route::post('/store',           'store')->name('slot.store')->middleware('PermissionCheck:slot_store');
        Route::get('/edit/{id}',        'edit')->name('slot.edit')->middleware('PermissionCheck:slot_update');
        Route::put('/update/{id}',      'update')->name('slot.update')->middleware('PermissionCheck:slot_update');
        Route::get('/delete/{id}',      'destroy')->name('slot.destroy')->middleware('PermissionCheck:slot_delete');
    });
    // End Slot Routes

});
