<?php

namespace Modules\Stream\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateStreamRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'         => 'required|max:255',
            'status_id'     => 'required|max:30',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'name.required'            => ___('validation.name_is_required'),
            'name.max'                 => ___('validation.name_must_be_less_than_255_characters'),
            'status_id.required'        => ___('validation.status_is_required'),
            'status_id.max'             => ___('validation.status_must_be_less_than_30_characters'),
        ];
    }
}
