@extends('backend.master')
@section('title')
{{ @$data['title'] }}
@endsection
@section('content')
<div class="page-content">

    {{-- breadecrumb Area S t a r t --}}
    @include('backend.ui-components.breadcrumb', [
    'title' => @$data['title'],
    'routes' => [
    route('dashboard') => ___('common.Dashboard'),
    route('admin.stream.index') => ___('blog.Stream'),
    '#' => @$data['title'],
    ],
    'buttons' => 0,
    ])
    {{-- breadecrumb Area E n d --}}

    <!--  category create start -->
    <div class="card ot-card">

        <div class="card-body">
            <form action="{{ route('admin.stream.update', $data['category']->id) }}" enctype="multipart/form-data" method="post">
                @method('PUT')
                @csrf

                {{-- Style Two --}}
                <div class="row mb-3">
                    <div class="col-lg-6">
                        <div class="row">
                            <div class="col-xl-12 col-md-6 mb-3">
                                <label for="title" class="form-label ">{{ ___('common.Name') }} <span class="fillable">*</span></label>
                                <input class="form-control ot-input @error('name') is-invalid @enderror" name="name" list="datalistOptions" id="name" value="{{ @$data['category']->name }}" placeholder="{{ ___('placeholder.Enter Name') }}">
                                @error('title')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>

                            <div class="col-xl-12 col-md-6 mb-3">
                                <label for="status" class="form-label ">{{ ___('common.Status') }}<span class="fillable">*</span></label>
                                <select class="form-select ot-input select2 @error('status_id') is-invalid @enderror" id="status" required name="status_id">
                                    <option value="1" @if($data['category']->status_id == 1) {{'selected'}} @endif>
                                        {{ ___('common.Active') }}
                                    </option>
                                    <option value="2" @if($data['category']->status_id == 2) {{'selected'}} @endif>
                                        {{ ___('common.Inactive') }}
                                    </option>
                                </select>
                                @error('status_id')
                                <div id="validationServer04Feedback" class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 mt-3">
                        <div class="text-left">

                            <button class="btn btn-lg ot-btn-primary" type="submit">
                                </span>{{ @$data['button'] }}</button>
                        </div>
                    </div>
                </div>
        </div>
    </div>

    <!--  category create end -->
</div>
@endsection