<?php

namespace Modules\Student\Entities;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Modules\Instructor\Entities\Instructor;
use Modules\Student\Entities\Student;

class CounselorSchedule extends Model
{
    use HasFactory;
    protected $table = 'counselor_schedule';

    protected $fillable = [
        'student_id',
        'instructor_id',
        'schedule_call_date',
        'call_time',
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function instructor()
    {
        return $this->belongsTo(Instructor::class);
    }
}
