<?php

namespace Modules\Student\Entities;

use App\Models\Country;
use App\Models\Upload;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Modules\Order\Entities\Enroll;
use Modules\Student\Entities\Referral;

class Student extends Model
{
    use HasFactory;

    protected $fillable = ['points', 'enroll_id'];

    public $casts = [
        'education' => 'json',
        'experience' => 'json',
        'skills' => 'json',
        'badges' => 'json',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }
    // relation with enrollments
    public function enrollments()
    {
        return $this->hasMany(Enroll::class, 'user_id', 'user_id');
    }
    public function completeEnrollments()
    {
        return $this->hasMany(Enroll::class, 'user_id', 'user_id')->where('is_completed', 1);
    }

    public function lastVisited()
    {
        return $this->hasOne(Enroll::class, 'user_id', 'user_id')->orderBy('visited', 'desc');
    }

    public function scopeFilter($query, $req)
    {
        $where = [];
        if (@$req->search && $req->search != 'undefined' && $req->search != 'null') {
            $query->whereHas('user', function ($query) use ($req) {
                $query->where('name', 'like', '%' . $req->search . '%');
            });
        }
        return $query->where($where);
    }

    public function image(): BelongsTo
    {
        return $this->belongsTo(Upload::class, 'certificate_image_id');
    }

    public function aadhaarCard()
    {
        return $this->belongsTo(Upload::class, 'aadhaar_card');
    }

    public function panCard()
    {
        return $this->belongsTo(Upload::class, 'pan_card');
    }

    public function scheduledCalls()
    {
        return $this->hasMany(CounselorSchedule::class);
    }

    //referral
  //referralCount
    

    
}
