<?php

namespace Modules\Student\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Request;

class ScheduleRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'instructor_id' => 'required|exists:instructors,id',
            'schedule_call_date' => 'required|date',
            'call_time' => 'required|string',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages()
    {
        return [
            'instructor_id.required' => ___('validation.Instructor ID is required'),
            'instructor_id.exists' => ___('validation.Instructor ID must exist in the instructors table'),
            'schedule_call_date.required' => ___('validation.Schedule call date is required'),
            'schedule_call_date.date' => ___('validation.Schedule call date must be a valid date'),
            'call_time.required' => ___('validation.Call time is required'),
            'call_time.string' => ___('validation.Call time must be a valid string'),
        ];
    }
}