<?php

namespace App\Http\Controllers\Frontend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Traits\ApiReturnFormatTrait;
use Modules\Blog\Interfaces\CareerInterface;

class CareerController extends Controller
{
    use ApiReturnFormatTrait;


    protected $career;

    public function __construct(CareerInterface $career)
    {

        $this->career             = $career;
    }


    public function index(Request $request)
    {
        try {
            $data['title']     = ___('frontend.Careers'); // title
            $data['careers']     = $this->career->getCareers();
            return view('frontend.career.index', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }

    }


    public function details(Request $request)
    {

        try {
            $data['title']              = ___('frontend.Career Details'); // title
            $data['career']               = $this->career->show($request->id);

            return view('frontend.career.details', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }

    }

}
