<?php

namespace App\Http\Controllers\Frontend;


use App\Http\Controllers\Controller;
use App\Models\AnswerLike;
use App\Models\Inquiry;
use App\Models\TblAnswer;
use App\Models\TblQuestion;
use App\Traits\ApiReturnFormatTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Modules\Blog\Interfaces\BlogInterface;
use Modules\Blog\Interfaces\CareerInterface;
use Modules\Brand\Interfaces\BrandInterface;
use Modules\Certificate\Interfaces\CertificateGenerateInterface;
use Modules\CMS\Interfaces\FeaturedCourseInterface;
use Modules\CMS\Interfaces\HomeSectionInterface;
use Modules\CMS\Interfaces\TestimonialInterface;
use Modules\Course\Interfaces\CourseCategoryInterface;
use Modules\Course\Interfaces\CourseInterface;
use Modules\Organization\Entities\Organization;
use Modules\Organization\Interfaces\OrganizationInterface;
use Modules\Slider\Interfaces\SliderInterface;
use Modules\Stream\Entities\Stream;
use Validator;

class HomeController extends Controller
{
    use ApiReturnFormatTrait;

    protected $slider;
    protected $blog;
    protected $career;
    protected $courseCategory;
    protected $brand;
    protected $homeSection;
    protected $featuredCourse;
    protected $testimonial;
    protected $certificateRepository;
    protected $course;
    protected $organization;

    // constructor injection
    public function __construct(
        SliderInterface $slider,
        BlogInterface $blog,
        CareerInterface $career,
        CourseCategoryInterface $courseCategory,
        BrandInterface $brand,
        HomeSectionInterface $homeSectionInterface,
        FeaturedCourseInterface $featuredCourseInterface,
        TestimonialInterface $testimonialInterface,
        CertificateGenerateInterface $certificateGenerateInterface,
        CourseInterface $courseInterface,
        OrganizationInterface $organizationInterface
    ) {
        $this->slider = $slider;
        $this->blog = $blog;
        $this->career = $career;
        $this->courseCategory = $courseCategory;
        $this->brand = $brand;
        $this->homeSection = $homeSectionInterface;
        $this->featuredCourse = $featuredCourseInterface;
        $this->testimonial = $testimonialInterface;
        $this->course = $courseInterface;
        $this->organization = $organizationInterface;
        $this->certificateRepository = $certificateGenerateInterface;
    }

    public function index(Request $request)
    {

        try {
            $data['title'] = ___('frontend.Home'); // title

            if (Cache::has('sections')) {
                $sections = Cache::get('sections');
            } else {
                $sections = $this->homeSection->model()->where('type', 'web')->where('status_id',1)->orderBy('order', 'ASC')->get(); // get all home section
                Cache::put('sections', $sections);
            }
            $data['section'] = $sections;

            return view('frontend.home', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('home')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }


    function applyNow(Request $request, $slug)
    {
        try {
            $data['title'] = ___('frontend.Apply Now'); // title
            $streams = Stream::get();
            $organization = Organization::where('slug',$slug)->first();
            $data['streams'] = $streams;
            $data['courses'] = $organization->courses()->with('category')->get();
            $data['organization'] = $organization;
            return view('frontend.apply_now', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('home')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }


    // ajax slider data start
    public function homeSliders()
    {

        // try {
            if (Cache::has('sliders')) {
                $sliders = Cache::get('sliders');
            } else {
                $sliders = $this->slider->getAllSlider();
                Cache::put('sliders', $sliders);
            }
            
            $data['sliders'] = $sliders;
            if ($data['sliders']) {
                $view = view('frontend.ajax.home.ot_banner_area', compact('data'))->render();
                $response['content'] = $view;
                $response['message'] = ___('frontend.Home Slider Found');
                return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
            }

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));

        // } catch (\Throwable $th) {

        //     return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        // }
    }
    // ajax slider data end

    public function homeAds()
    {

        try {
            if (Cache::has('add_sliders')) {
                $sliders = Cache::get('sliders');
            } else {
                $sliders = $this->slider->getAllAds();
                Cache::put('add_sliders', $sliders);
            }

            $data['sliders'] = $sliders;
            if ($data['sliders']) {
                $data['title'] = ___('frontend.Ad & Blog Area');
                $view = view('frontend.ajax.home.ot_ads_area', compact('data'))->render();
                $response['content'] = $view;
                $response['message'] = ___('frontend.Home Slider Found');
                return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
            }

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        } catch (\Throwable $th) {

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }

    // ajax featured courses data start
    public function featuredCourses()
    {
        try {
            if (Cache::has('featured_courses')) {
                $featuredCourses = Cache::get('featured_courses');
            } else {
                $featuredCourses = $this->featuredCourse->model()->active()->with('course')->orderBy('id', 'ASC')->limit(4)->get();
                Cache::put('featured_courses', $featuredCourses);
            }
            $data['courses'] = $featuredCourses;
            $data['title'] = ___('frontend.Featured Courses');
            $data['url'] = route('courses') . '?type=featured';
            $view = view('frontend.ajax.home.ot_featured_courses_area', compact('data'))->render();
            $response['content'] = $view;
            $response['message'] = ___('frontend.Featured Courses');
            return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }
    // ajax featured courses data end

    // ajax popular courses data start
    public function popularCategory()
    {

        try {
            $data['popularCategories'] = $this->courseCategory->popularCategory();
            $data['section_title'] = ___('frontend.Popular category');
            if ($data['popularCategories']) {
                $view = view('frontend.ajax.home.ot_categories_area', compact('data'))->render();
                $response['content'] = $view;
                $response['message'] = ___('frontend.Popular category found');
                return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
            }
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        } catch (\Throwable $th) {

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }
    // ajax popular courses data end

    // ajax latest courses data start
    public function latestCourses()
    {
        // dd('here')
        // try {
            // if (Cache::has('latest_courses')) {
            //     $latest = Cache::get('latest_courses');
            // } else {
            //     Cache::put('latest_courses', $latest);
            // }
            $latest = $this->organization->model()->active()->limit(4)->get();
            // dd($latest);
            $data['courses'] = $latest;
            $data['title'] = ___('frontend.Trending Institutes');
            $data['url'] = route('institutes') . '?sort=latest';
            $view = view('frontend.ajax.home.ot_institute_area', compact('data'))->render();
            $response['content'] = $view;
            $response['message'] = ___('frontend.Latest Courses');
            // dd($response);
            return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
        // } catch (\Throwable $th) {
        //     return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        // }
    }
    // ajax latest courses data end

    // ajax best rated courses data start
    public function bestRatedCourses()
    {
        try {
            // if (Cache::has('best_rated_courses')) {
            //     $courses = Cache::get('best_rated_courses');
            // } else {
            //     // No rating column in organization table
            //     // $courses = $this->organization->model()->active()->orderBy('rating', 'DESC')->limit(4)->get();
            //     $courses = $this->organization->model()->active()->limit(4)->get();
            //     // Cache::put('best_rated_courses', $courses);
            // }
            
            $courses = $this->organization->model()->active()->limit(4)->get();
            $data['courses'] = $courses;
            $data['title'] = ___('frontend.Best Rated Institutes');
            $data['url'] = route('institutes') . '?sort=best_rated';
            $view = view('frontend.ajax.home.ot_institute_area', compact('data'))->render();
            $response['content'] = $view;
            $response['message'] = ___('frontend.Best Rated Institutes');
            return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
        } catch (\Throwable $th) {
            dd($th);
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }
    // ajax best rated courses data end
    // ajax best selling courses data start
    public function mostPopularCourses()
    {
        try {
            if (Cache::has('most_popular_courses')) {
                $courses = Cache::get('most_popular_courses');
            } else {
                $courses = $this->course->model()->active()->visible()->orderBy('total_sales', 'DESC')->limit(4)->get();
                Cache::put('most_popular_courses', $courses);
            }
            $data['courses'] = $courses;
            $data['title'] = ___('frontend.Popular Courses');
            $data['url'] = route('courses') . '?sort=popular';
            $view = view('frontend.ajax.home.ot_courses_area', compact('data'))->render();
            $response['content'] = $view;
            $response['message'] = ___('frontend.Most Popular Courses');
            return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
        } catch (\Throwable $th) {
            dd($th);
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }
    // ajax best selling courses data end
    // ajax discount courses data start
    public function homePageCareers()
    {
        
        try {

            $data['careers'] = $this->career->homeCareer();
            $data['section_title'] = ___('frontend.High Rated careers');

            if ($data['careers']) {
                $view = view('frontend.ajax.home.ot_careers_area', compact('data'))->render();
                $data['content'] = $view;
                $data['message'] = "Career found";
                return $this->responseWithSuccess(___('alert.Data found.'), $data); // return success response from ApiReturnFormatTrait
            }
            
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        } catch (\Throwable $th) {
            dd($th);
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }
    // ajax discount courses data end

    // ajax testimonials data start
    public function testimonials()
    {
        try {
            if (Cache::has('testimonials')) {
                $testimonials = Cache::get('testimonials');
            } else {
                $testimonials = $this->testimonial->model()->active()->orderBy('id', 'DESC')->limit(4)->get();
                Cache::put('testimonials', $testimonials);
            }
            $data['testimonials'] = $testimonials;
            $data['title'] = ___('frontend. Teachers Recommendation');
            $view = view('frontend.ajax.home.ot_testimonials_area', compact('data'))->render();
            $response['content'] = $view;
            $response['message'] = ___('frontend.Testimonials');
            return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }

    // ajax menu categories start

    public function menuCategories()
    {

        try {
            if (Cache::has('menu_categories')) {
                $data['categories'] = Cache::get('menu_categories');
            } else {
                $data['categories'] = $this->courseCategory->filter(['parent_id' => null])->active()->orderBy('id', 'DESC')->get();
                Cache::put('menu_categories', $data['categories']);
            }
            $view = view('frontend.ajax.header.categories', compact('data'))->render();
            $response['content'] = $view;
            $response['message'] = ___('frontend.Menu Categories');
            return $this->responseWithSuccess(___('alert.Data found.'), $response); // return success response from ApiReturnFormatTrait
        } catch (\Throwable $th) {
            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }
    // ajax menu categories end

    public function blogs()
    {

        try {

            $data['blogs'] = $this->blog->homeBlog();
            $data['section_title'] = ___('frontend.Our Recent Blogs');

            if ($data['blogs']) {
                $view = view('frontend.ajax.home.ot_blog_area', compact('data'))->render();
                $data['content'] = $view;
                $data['message'] = ___('frontend.Blogs Found');
                return $this->responseWithSuccess(___('alert.Data found.'), $data); // return success response from ApiReturnFormatTrait
            }

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        } catch (\Throwable $th) {

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function brands()
    {

        try {

            $data['brands'] = $this->brand->getAllBrands(); // This function comes from BlogRepository
            $data['section_title'] = ___('frontend.Trusted By Thousands');

            if ($data['brands']) {
                $view = view('frontend.ajax.home.ot_brands', compact('data'))->render();
                $data['content'] = $view;
                $data['message'] = ___('frontend.Brands Found');
                return $this->responseWithSuccess(___('alert.Data found.'), $data); // return success response from ApiReturnFormatTrait
            }

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        } catch (\Throwable $th) {

            return $this->responseWithError(___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function certificateTrack(Request $request)
    {
        try {
            $data['title'] = ___('frontend.Track_Your_Certificate'); // title
            return view('frontend.certificate', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->route('home')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
    public function certificateView(Request $request)
    {

        try {
            $certificate = $this->certificateRepository->model()->where('certificate_id', $request->certificate_id)->first();
            if ($certificate) {
                $data['certificate'] = $certificate;
                $data['title'] = ___('frontend.Certificate_Tracked'); // title
                return view('frontend.certificate', compact('data'));
            }
            return redirect()->route('front.certificate')->with('danger', ___('alert.certificate_not_valid'));

        } catch (\Throwable $th) {
            return redirect()->route('front.certificate')->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }

    }

    public function questionAnswers()
    {
        try {
        $data['title'] = ___('frontend.Question & Answer'); // title
        $data['questions'] = TblQuestion::with('user', 'answers')->get();
        return view('frontend.page.question_and_answers', compact('data'));
        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }
    // termsConditions page end

    public function storeQuestion(Request $request)
    {
        try {
            //check if user is logged in
            if (!auth()->check()) {
                return redirect()->back()->with('danger', ___('alert.Please login to submit question.'));
            }
            // dd($request->all());
            $question  = new TblQuestion();
            $question->question = $request->question;
            $question->user_id = auth()->id();
            $question->save();
            return redirect()->route('frontend.question_answers')->with('success', ___('alert.Question submitted successfully.'));
            

        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    //store answer
    public function storeAnswer(Request $request)
    {
        try {
            // dd($request->all());
            $answer  = new TblAnswer();
            $answer->answer = $request->answer;
            $answer->question_id = $request->question_id;
            $answer->user_id = auth()->id();
            $answer->save();
            return redirect()->back()->with('success', ___('alert.Answer submitted successfully.'));
            

        } catch (\Throwable $th) {
            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }

    public function like($id)
    {
        $answer = TblAnswer::findOrFail($id);

        // Check if the user has already liked the answer
        $existingLike = AnswerLike::where('answer_id', $id)->where('user_id', auth()->id())->first();
        if ($existingLike) {
            if ($existingLike->is_like) {
                // If already liked, remove the like
                $existingLike->delete();
            } else {
                // If disliked, change to like
                $existingLike->is_like = true;
                $existingLike->save();
            }
        } else {
            // Create a new like
            AnswerLike::create([
                'answer_id' => $id,
                'user_id' => auth()->id(),
                'is_like' => true,
            ]);
        }

        $likes = AnswerLike::where('answer_id', $id)->where('is_like', true)->count();
        $dislikes = AnswerLike::where('answer_id', $id)->where('is_like', false)->count();

        return response()->json(['success' => true, 'likes' => $likes, 'dislikes' => $dislikes]);
    }

    public function dislike($id)
    {
        $answer = TblAnswer::findOrFail($id);

        // Check if the user has already disliked the answer
        $existingDislike = AnswerLike::where('answer_id', $id)->where('user_id', auth()->id())->first();
        if ($existingDislike) {
            if (!$existingDislike->is_like) {
                // If already disliked, remove the dislike
                $existingDislike->delete();
            } else {
                // If liked, change to dislike
                $existingDislike->is_like = false;
                $existingDislike->save();
            }
        } else {
            // Create a new dislike
            AnswerLike::create([
                'answer_id' => $id,
                'user_id' => auth()->id(),
                'is_like' => false,
            ]);
        }

        $likes = AnswerLike::where('answer_id', $id)->where('is_like', true)->count();
        $dislikes = AnswerLike::where('answer_id', $id)->where('is_like', false)->count();

        return response()->json(['success' => true, 'likes' => $likes, 'dislikes' => $dislikes]);
    }

 


    public function storeInquiry(Request $request)
    {
        // dd($request->all());
        try {

        //validation rules

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            // 'email' => 'required|email',
            'phone' => 'required',
            'stream_id' => 'required',
            'course_id' => 'nullable',
            'organization_id' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('danger', ___('alert.Please fill all the fields Correct.'));
        }

        
        $inquiry  = new Inquiry();
        $inquiry->name = $request->name;
        $inquiry->email = $request->email;
        $inquiry->phone = $request->phone;
        $inquiry->stream_id = $request->stream_id;
        if($request->has('course_id')){
           $inquiry->course_id = $request->course_id;
        }
        if($request->has('level')){
            $inquiry->level = $request->level;
        }
        
        $inquiry->organization_id = $request->organization_id;
        $inquiry->save();
        return redirect()->back()->with('success', ___('alert.Inquiry submitted successfully.'));


        } catch (\Throwable $th) {


            return redirect()->back()->with('danger', ___('alert.something_went_wrong_please_try_again'));
        }
    }


}
