<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class XssSanitization
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        $input = $request->except(['content', 'description', 'meta_description', 'requirements', 'outcomes', 'details', 'review', 'lesson_text', 'instruction', 'note', 'question', 'answer', 'comment', 'overview', 'eligibility', 'curriculum', 'fees', 'career_opportunity']);
        array_walk_recursive($input, function (&$input) {
            $input = strip_tags($input);
        });

        $request->merge($input);
        return $next($request);
    }

    protected $except = [
        '/admin/pages/update*',
    ];
}
