<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TblAnswer extends Model
{
    use HasFactory;

    protected $table = 'tbl_answers';

    // Specify the fillable attributes
    protected $fillable = [
        'answer',
        'user_id',
        'question_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function question()
    {
        return $this->belongsTo(TblQuestion::class);
    }

    public function likes()
    {
        return $this->hasMany(AnswerLike::class, 'answer_id')->where('is_like', true);
    }

    /**
     * Get the dislikes for the answer.
     */
    public function dislikes()
    {
        return $this->hasMany(AnswerLike::class, 'answer_id')->where('is_like', false);
    }


}
