@extends('frontend.layouts.master')
@section('title', @$data['title'])
@section('content')

    <div class="container mb-5 ">
        <div class="courseHeader mt-4">
            <div class="courseBanner">
                <img src="{{ showImage(@$data['career']->imageDetail->original) }}"alt="">
            </div>
            <div class="courseHeaderTitle">
                <div class="row">
                    <div class="col-lg-7 col-xl-7  col-md-12">
                        <h2 class=""><a href="" style="color:#B90A0B">{{ @$data['career']->name }}</a></h2>
                    </div>
                    <div class="col-lg-5 col-xl-5  col-md-12">
                        <span class="courseCallback">

                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navbar  -->
        <nav class="menu-inner mb-5">
            <ul>
                <li><a class="activeStatus" href="#overview">Overview</a></li>
                <li><a href="#eligibility">Eligibility</a></li>
                <li><a href="#jobs">Job Roles</a></li>
                <li><a href="#salary">Salary</a></li>
                <li><a href="#careerOpportunity">Career Opportunity</a></li>
                <li><a href="#topCollege">Top Colleges</a></li>
            </ul>
        </nav>

        <!-- content section -->
        <div class="row">
            <div class="col-lg-9 col col-md-9">
                <h2 class="fs-title text-center">{{ @$data['career']->title }}</h2>
                @if ($data['career']->overview)
                    <section id="overview" class=" pt-1">
                        <h2 class="fs-title mt-5">Overview</h2>
                        <?= @$data['career']->overview ?>
                    </section>
                @endif

                @if ($data['career']->eligibility)
                    <section id="eligibility" class=" pt-1">
                        <h2 class="fs-title mt-5">Eligibility to become a Doctor</h2>
                        <?= @$data['career']->eligibility ?>
                    </section>
                @endif

                @if ($data['career']->syllabus)
                    <section id="syllabus" class=" pt-2">
                        <h2 class="fs-title mt-5">Subjects Year Wise</h2>
                        <?= @$data['career']->syllabus ?>
                    </section>
                @endif

                @if ($data['career']->overview)
                    <section id="jobs" class=" pt-2">
                        <h2 class="fs-title mt-5">Types of Job Roles</h2>
                        <?= @$data['career']->job_roles ?>
                    </section>
                @endif

                @if ($data['career']->salary)
                    <section id="salary" class=" pt-2">
                        <h2 class="fs-title mt-5"> Pay Scale/Salary of Doctor</h2>
                        <?= @$data['career']->salary ?>
                    </section>
                @endif

                @if ($data['career']->career_opportunity)
                    <section id="careerOpportunity" class=" pt-2">
                        <h2 class="fs-title mt-5"> Pay Scale/Salary</h2>
                        <?= @$data['career']->career_opportunity ?>
                    </section>
                @endif

                @if ($data['career']->top_colleges)
                    <section id="topCollege" class=" pt-2 ">
                        <h2 class="fs-title mt-5">Top Colleges</h2>
                        <?= @$data['career']->top_colleges ?>
                    </section>
                @endif
            </div>
            <div class="col-lg-3 col col-md-3">
                <h3> ad section</h3>
            </div>
        </div>
    </div>

@endsection

<script></script>
