@extends('frontend.layouts.master')
@section('title', @$data['title'] ?? 'Careers')
@section('content')
    <!--Bradcam S t a r t -->
    @include('frontend.partials.breadcrumb', [
        'breadcumb_title' => @$data['title'],
    ])
    <!--End-of Bradcam  -->
    <section class="blog-area section-padding">
        <div class="container">
            <div class="row g-24">
                @foreach ($data['careers'] as $key => $career)
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="blog-single h-calc">
                            <div class="blog-img-cap">
                                <div class="blog-img imgEffect">
                                    <a href="{{ route('career_details', $career->id) }}">
                                        <img src="{{ showImage(@$career->imageDetail->original, 'backend/uploads/default-images/blog/blog' . $key + 1 . '.jpg') }}"
                                            alt="img" class="img-cover">
                                    </a>
                                </div>
                                <div class="blog-cap">
                                    <h3><a href="{{ route('career_details', $career->id) }}"
                                            class="title colorEffect line-clamp-2 font-600">{{ Str::limit(@$career->title, 20) }}</a>
                                    </h3>
                                    <p class="pera mb-15">{{ Str::limit(strip_tags(@$career->overview), 100) }}</p>
                                    <p class="font-600">{{ $career->created_at->diffForHumans() }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="row">
                <div class="col-lg-12">
                    {{ $data['careers']->links('frontend.layouts.partials.pagination') }}
                </div>
            </div>

        </div>
    </section>
    <!-- End-of Blog -->
@endsection
