@extends('frontend.layouts.master')
@section('title', @$data['title'])
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('frontend/plyr/plyr.css') }}">
    <link rel="stylesheet" type="text/css" href="updated_frontend/css/home/college.css">
@endsection

@push('meta')
    <meta itemprop="name" content="{{ @$data['course']->meta_title }}">
    <meta itemprop="image" content="{{ showImage(@$data['course']->metaImage->original) }}">
    <meta itemprop="description" content="{{ @$data['course']->meta_description }}">
    <meta name="twitter:title" content="{{ @$data['course']->meta_title }}">
    <meta name="twitter:image" content="{{ showImage(@$data['course']->metaImage->original) }}">
    <meta name="twitter:description" content="{{ @$data['course']->meta_description }}">
    <meta property="og:site_name" content="{{ @$data['course']->meta_title }}" />
    <meta property="og:title" content="{{ @$data['course']->meta_title }}" />
    <meta property="og:description" content="{{ @$data['course']->meta_description }}" />
    <meta property="og:image" content="{{ showImage(@$data['course']->metaImage->original) }}" />
    <meta name="description" content="{{ @$data['course']->meta_description }}">
    <meta name="keywords" content="{{ @$data['course']->meta_keyword }}">

    <style>


    </style>
@endpush
@section('content')
    <!--Bradcam S t a r t -->
    @include('frontend.partials.breadcrumb', [
        'breadcumb_title' => @$data['title'],
    ])
    <!-- Breadcrumb Area S t a r t-->
    
    <!-- End-of Breadcrumb-->
    <!--End-of Bradcam  -->


    <!-- course-details  S t a r t-->
    <div class="ot-course-details section-padding2 mt-2">
        <div class="container">
            <div class="row">
                <div class="col-xl-12 col-lg-12 col-md-12">
                    <div class="ot-course-details-inner">
                        <!-- <h3 class="ot-course-title">{{ @$data['course']->title }}hello</h3> -->
                        <!-- <img src="updated_frontend/images/university/mumbai-Banner.jpg" alt="img">
                        <h3 class="ot-course-title">Sanskriti University Mathura - Admission 2024, Fees, Courses, Placement, Ranking</h3> -->
                        <div class="d-flex course-author gap-12 align-items-center">
                            <div class="thumb course-widget-author-img">
                                <!-- <img class="img-cover"
                                    src=" {{ showImage(@$data['course']->instructor->image->original) }} " alt="img"> -->
                                    <img class="img-cover" src="{{url('/updated_frontend/images/university/Mumbai_University-logo.webp')}}" alt="img">
                            </div>
                            <div class="author-info w-100">
                                <!-- <h5><a href="{{ route('frontend.instructor.details', [$data['course']->user->name, $data['course']->user->id]) }}">{{ @$data['course']->instructor->name }}</a></h5> -->

                                <div><h3 class="ot-course-title">University of Mumbai NCR Haryana, Bahadurgarh</h3></div>
                                <!-- <p>{{ @$data['course']->instructor->instructor->designation }}</p> -->
                                <div class="d-flex align-items-center course-star-rating ">
                                    <!-- <span class="rating-count text-16 mr-2">{{ @$data['course']->rating }} </span> -->
                                    <span class="text-16 pl-8 pr-8">{{ rating_ui(@$data['course']->rating, '16') }} </span>
                                    <span class="total-rating  "> ( @if ($data['course']->total_review > 0)
                                        {{ numberFormat($data['course']->total_review) }}
                                        {{ ___('frontend.Reviews') }}
                                        @else
                                        {{ numberFormat(0.0) }}
                                        @endif )review</span>
                                </div>
                                <div class="college-info">
                                    <div class="d-flex">
                                        <div style=" color:black;"><i class="fa-solid fa-location-dot"></i> location</div> 
                                        <div style="margin-left:20px; color:black;">Private Institute</div>
                                    </div>
                                    <div class=" d-flex brouchar">
                                    <button class="btn">Apply Now</button>
                                    <button class="btn">Brochure</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="d-flex gap-20 flex-wrap">
                            <div class="flex-fill">
                                <div class="d-flex align-items-center course-star-rating">
                                    <span class="rating-count text-16 mr-2">{{ @$data['course']->rating }} </span>
                                    <span class="text-16 pl-8 pr-8">{{ rating_ui(@$data['course']->rating, '16') }} </span>
                                    <span class="total-rating  "> ( @if ($data['course']->total_review > 0)
                                            {{ numberFormat($data['course']->total_review) }}
                                            {{ ___('frontend.Reviews') }}
                                        @else
                                            {{ numberFormat(0.0) }}
                                        @endif )</span>
                                </div>
                                <div
                                    class="d-flex align-items-center gap-12 course-duration d-flex align-items-center gap-12">
                                    <h5>{{ minutes_to_hours($data['course']->course_duration) }}</h5>
                                    <div class="bulet-rouned"></div>
                                    <span>{{ @$data['course']->lessons->count() }}
                                        {{ ___('frontend.Lesson') }} </span>
                                </div>
                            </div>
                        </div> -->
                        <!-- <p class="course_description"><?= $data['course']->short_description ?></p> -->

                        <!-- course details tab  -->
                        <ul class="nav course-details-tabs mb-40 mt-2" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="Overview-tab" data-bs-toggle="tab"
                                    data-bs-target="#Overview" type="button" role="tab" aria-controls="Overview"
                                    aria-selected="true">
                                    <!-- <i class="ri-dashboard-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Overview') }}</span> -->
                                    <span>College Info</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Curriculum-tab" data-bs-toggle="tab"
                                    data-bs-target="#Curriculum" type="button" role="tab" aria-controls="Curriculum"
                                    aria-selected="false">
                                    <!-- <i class="ri-file-list-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Curriculum') }}</span> -->
                                    <span>Courses</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="{{ $data['user_type'] }}-tab" data-bs-toggle="tab"
                                    data-bs-target="#{{ $data['user_type'] }}" type="button" role="tab"
                                    aria-controls="{{ $data['user_type'] }}" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ $data["user_type"] }}</span> -->
                                    <span>Admissions</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Placements-tab" data-bs-toggle="tab" data-bs-target="#Placements"
                                    type="button" role="tab" aria-controls="Placements" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Placements</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Review-tab" data-bs-toggle="tab" data-bs-target="#Review"
                                    type="button" role="tab" aria-controls="Review" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Reviews</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Campus-tab" data-bs-toggle="tab" data-bs-target="#Campus"
                                    type="button" role="tab" aria-controls="Campus" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Campus</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Faculty-tab" data-bs-toggle="tab" data-bs-target="#Faculty"
                                    type="button" role="tab" aria-controls="Faculty" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Faculty</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Gallery-tab" data-bs-toggle="tab" data-bs-target="#Gallery"
                                    type="button" role="tab" aria-controls="Gallery" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Gallery</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Q&A-tab" data-bs-toggle="tab" data-bs-target="#Q&A"
                                    type="button" role="tab" aria-controls="Q&A" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Q&A</span>
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="Blog-tab" data-bs-toggle="tab" data-bs-target="#Blog"
                                    type="button" role="tab" aria-controls="Blog" aria-selected="false">
                                    <!-- <i class="ri-user-2-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Review') }}</span> -->
                                    <span>Blog & News</span>
                                </button>
                            </li>

                        </ul>
                        <div class="tab-content w-100" id="myTabContent">
                            <!-- overview -->
                            <div class="tab-pane fade show active" id="Overview" role="tabpanel"
                                aria-labelledby="Overview-tab">

                                @if (@$data['course']->outcomes)
                                    <!-- course outcomes s t a r t  -->
                                    <div class="course-tab-widget">
                                        <h3 class="course-details-title">
                                            {{ ___('frontend.What You will Learn From This course') }}hellooo</h3>
                                        <ul class="course-details-list">
                                            <?= $data['course']->outcomes ?>
                                        </ul>
                                    </div>
                                    <!--End-of outcomes tab  -->
                                @endif

                                @if (@$data['course']->sections->count() > 0)
                                    <!-- course tab curriculam s t a r t  -->
                                    <div class="course-tab-widget">
                                        <h3 class="course-details-title">{{ ___('frontend.Course Curriculum') }}over</h3>
                                        <?= $data['curriculum'] ?>

                                    </div>
                                    <!--End-of course tab  -->
                                @endif
                                @if (@$data['course']->requirements)
                                    <!-- course Requirements s t a r t  -->
                                    <div class="course-tab-widget">
                                        <h3 class="course-details-title">{{ ___('frontend.Requirements') }}hhhhh</h3>
                                        <ul class="course-details-list">
                                            <?= $data['course']->requirements ?>
                                        </ul>
                                    </div>
                                    <!--End-of Requirements tab  -->
                                @endif

                                <!-- course Description s t a r t  -->
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">{{ ___('frontend.Description') }}hello</h3>
                                    <ul class="course-details-list">
                                        <?= $data['course']->description ?>
                                    </ul>
                                </div>
                                <!--End-of Description tab  -->

                                <!-- course tab profile s t a r t  -->
                                <div class="course-tab-widget">
                                    <?= $data['profile'] ?>
                                </div>
                                <!--End-of course tab  -->

                                <!-- course tab review s t a r t  -->
                                <div class="course-tab-widget">
                                    <?= $data['review'] ?>
                                </div>
                                <!-- End-of course tab review  -->


                            </div>

                            <!-- Courses Section ----------------curriculam -->
                            <div class="tab-pane fade" id="Curriculum" role="tabpanel" aria-labelledby="Curriculum-tab">
                                <!-- course tab curriculam s t a r t  -->
                                <div class="course-tab-widget">
                                <h3 class="course-details-title">Course</h3>
                                    <h3 class="course-details-title">{{ ___('frontend.Course Curriculum') }}</h3>
                                    @if (@$data['course']->sections->count() > 0)
                                        <?= $data['curriculum'] ?>
                                    @else
                                        <div class="text-left">
                                            <p class="text-left">{{ ___('frontend.No Curriculum Found') }}</p>
                                        </div>
                                    @endif
                                </div>
                                <!--End-of course tab  -->
                            </div>

                            <!-- Admissions Section ---------------------->
                            <div class="tab-pane fade" id="{{ $data['user_type'] }}" role="tabpanel" aria-labelledby="{{ $data['user_type'] }}-tab">
                                <!-- course tab profile s t a r t  -->
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Admissions</h3>
                                    <!-- <?= $data['profile'] ?> -->
                                </div>
                                <!--End-of course tab  -->
                            </div>

                            <!-- Placements section ------------------->
                            <div class="tab-pane fade" id="Placements" role="tabpanel" aria-labelledby="Placements-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Placements</h3>
                                </div>
                            </div>

                            <!-- review SECTION ------------------------>
                            <div class="tab-pane fade" id="Review" role="tabpanel" aria-labelledby="Review-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Review</h3>
                                </div>

                                
                                <!-- End-of course tab review  -->

                            </div>

                            <!-- Campus section ---------------------- -->
                            <div class="tab-pane fade" id="Campus" role="tabpanel" aria-labelledby="Campus-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Campus</h3>
                                </div>

                                
                                <!-- End-of course tab review  -->

                            </div>

                            <!-- Faculty Section ---------------- -->
                            <div class="tab-pane fade" id="Faculty" role="tabpanel" aria-labelledby="Faculty-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Faculty</h3>
                                </div>
                            </div>

                            <!-- Gallery Section -->
                            <div class="tab-pane fade" id="Gallery" role="tabpanel" aria-labelledby="Gallery-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Gallery</h3>
                                </div>
                            </div>

                            <!-- Q&A Section --------------->
                            <div class="tab-pane fade" id="Q&A" role="tabpanel" aria-labelledby="Q&A-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Q & A</h3>
                                    <div class="theme-according mb-24" id="accordion1">
                                      <div class="card">
                                        <div class="card-header pink_bg" id="four4">
                                          <h5 class="mb-0">
                                            <button class="btn btn-link text-white collapsed" data-bs-toggle="collapse" data-bs-target="#collapseFour0"                                      aria-expanded="false" aria-controls="four4">
                                              <span class="course-curriculum-title">Section 1</span>
                                              <span class="course-curriculum-lesson"> 3 Lesson - 2h </span>
                                            </button>
                                          </h5>
                                        </div>
                                        <div class="collapse" id="collapseFour0" data-parent="#accordion1" style="">
                                          <div class="card-body">
                                            <ul class="course-video-lists">
                                              <li><i class="ri-play-circle-line"></i>Lesson 1</li>
                                              <li><i class="ri-question-line"></i>Quiz 1</li>
                                              <li><i class="ri-question-line"></i>Quiz 1</li>
                                            </ul>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Blog & News ------------------ -->
                            <div class="tab-pane fade" id="Blog" role="tabpanel" aria-labelledby="Blog-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Blog & News</h3>
                                </div>
                            </div>
                        </div>
                        <!-- COURSE_DETAILS_TABS::END    -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End-of course-details-->

@endsection


@section('scripts')
    <script src="{{ asset('frontend/js/__course.js') }}" type="module"></script>
@endsection
