@php
    $isHomePage = Request::is('home/ajax/best-rated-courses') || Request::is('home/ajax/latest-courses');
@endphp

<div class="course-widget radius-12 h-calc " style="background-color:white; border:1px solid black">
    <div class="course-widget-img position-relative overflow-hidden">
        <a href="{{ $course->slug ? route('frontend.organizationDetails', $course->slug) : 'javascript:void(0);' }}"> 
        <img src="{{ showImage(@$course->thumbnail->original) }}" class="img-cover" alt="img">
         </a>
    </div>
    <div class="widget-mid w-100 ">
        <div class="course-widget-info mb-18">
            <div class="course-widget-info-title mb-3">
                

                <a href="{{ $course->slug ? route('frontend.organizationDetails', $course->slug) : 'javascript:void(0);' }}">
                    <h4 class="title colorEffect line-clamp-2 text-18 font-500 text-center">
                        {{ Str::limit(@$course->user->name, @$limit ?? 29) }}
                    </h4>
                </a>
                <p class="text-black text-12 font-400  mt-2 text-center">
                    {{ Str::words(@$course->about_me, 20) }}
                </p>
            
                
                @if (!@$isHomePage)
                <p class="text-black text-12 font-400 mt-2 text-center">
                    Location: {{ @$course->city.', '.@$course->state }} <br>
                    <!--NIRF Ranking: {{ @$course->nirf_ranking ?? 'XXXX' }} <br>-->
                    Institution Type: {{ @$course->organization_type == 1 ? ___('organization.Public') : ___('organization.Private') }}
                </p>
                @endif
            </div>
        </div>
        @if (@$course->user->role_id != 5)
        
        @else
        <div class="course-widget-author d-flex align-items-center gap-12">
        
            <div class="">
        
            </div>
        </div>
        @endif

        <div class="widget-footer">

            @if (auth()->check() &&
            auth()->user()->userCourseEnroll->where('course_id', $course->id)->count() > 0)
        
            @else
            <div class="d-flex justify-content-end align-items-center flex-wrap">

                <a href="{{ $course->slug ? route('frontend.organizationDetails', $course->slug) : 'javascript:void(0);' }}" class="btn-primary-outline mb-7">
                    {{ ___('frontend.Read more') }} </a>
            </div>
            @endif

        </div>
    </div>

</div>