@extends('frontend.layouts.master')
@section('title', @$data['title'])
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('frontend/plyr/plyr.css') }}">
    <link rel="stylesheet" type="text/css" href="updated_frontend/css/home/college.css">
@endsection

@push('meta')
    <meta itemprop="name" content="{{ @$data['course']->meta_title }}">
    <meta itemprop="image" content="{{ showImage(@$data['course']->metaImage->original) }}">
    <meta itemprop="description" content="{{ @$data['course']->meta_description }}">
    <meta name="twitter:title" content="{{ @$data['course']->meta_title }}">
    <meta name="twitter:image" content="{{ showImage(@$data['course']->metaImage->original) }}">
    <meta name="twitter:description" content="{{ @$data['course']->meta_description }}">
    <meta property="og:site_name" content="{{ @$data['course']->meta_title }}" />
    <meta property="og:title" content="{{ @$data['course']->meta_title }}" />
    <meta property="og:description" content="{{ @$data['course']->meta_description }}" />
    <meta property="og:image" content="{{ showImage(@$data['course']->metaImage->original) }}" />
    <meta name="description" content="{{ @$data['course']->meta_description }}">
    <meta name="keywords" content="{{ @$data['course']->meta_keyword }}">

    <style>


    </style>
@endpush
@section('content')
    <!--Bradcam S t a r t -->
    <div class="CollegeBanner container" >
        <img src="{{asset('/updated_frontend/images/college/IIT_indoreBanner.png')}}" alt="" style="width:100%; height:400px;">
    </div>
   
    <!-- Breadcrumb Area S t a r t-->
    
    <!-- End-of Breadcrumb-->
    <!--End-of Bradcam  -->

    <!-- course-details  S t a r t-->
    <div class="ot-course-details pt-2 mt-2">
        <div class="container">
            <div class="row">
                <div class="col-xl-12 col-lg-12 col-md-12">
                    <div class="ot-course-details-inner">
                        <!-- <h3 class="ot-course-title">{{ @$data['course']->title }}hello</h3> -->
                        <!-- <img src="updated_frontend/images/university/mumbai-Banner.jpg" alt="img">
                        <h3 class="ot-course-title">Sanskriti University Mathura - Admission 2024, Fees, Courses, Placement, Ranking</h3> -->
                        <div class="d-flex course-author gap-12 align-items-center">
                            <div class="thumb course-widget-author-img">
                                <!-- <img class="img-cover"
                                    src=" {{ showImage(@$data['course']->instructor->image->original) }} " alt="img"> -->
                                    <img class="img-cover" src="{{url('/updated_frontend/images/university/Mumbai_University-logo.webp')}}" alt="img">
                            </div>
                            <div class="author-info w-100">
                                <!-- <h5><a href="{{ route('frontend.instructor.details', [$data['course']->user->name, $data['course']->user->id]) }}">{{ @$data['course']->instructor->name }}</a></h5> -->

                                <div><h3 class="ot-course-title">Indian Institute Of Management–Indore (IIM–Indore)</h3></div>
                                <!-- <p>{{ @$data['course']->instructor->instructor->designation }}</p> -->
                                <div class="d-flex align-items-center course-star-rating ">
                                    <!-- <span class="rating-count text-16 mr-2">{{ @$data['course']->rating }} </span> -->
                                    <span class="text-16 pl-8 pr-8">{{ rating_ui(@$data['course']->rating, '16') }} </span>
                                    <span class="total-rating  "> ( @if ($data['course']->total_review > 0)
                                        {{ numberFormat($data['course']->total_review) }}
                                        {{ ___('frontend.Reviews') }}
                                        @else
                                        {{ numberFormat(0.0) }}
                                        @endif )review</span>
                                </div>
                                <div class="college-info">
                                    <div class="d-flex">
                                        <div style=" color:black;"><i class="fa-solid fa-location-dot"></i> location</div> 
                                        <div style="margin-left:20px; color:black;">Private Institute</div>
                                    </div>
                                    <div class=" d-flex brouchar">
                                    <button class="btn">Apply Now</button>
                                    <button class="btn">Download Brochure</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="d-flex gap-20 flex-wrap">
                            <div class="flex-fill">
                                <div class="d-flex align-items-center course-star-rating">
                                    <span class="rating-count text-16 mr-2">{{ @$data['course']->rating }} </span>
                                    <span class="text-16 pl-8 pr-8">{{ rating_ui(@$data['course']->rating, '16') }} </span>
                                    <span class="total-rating  "> ( @if ($data['course']->total_review > 0)
                                            {{ numberFormat($data['course']->total_review) }}
                                            {{ ___('frontend.Reviews') }}
                                        @else
                                            {{ numberFormat(0.0) }}
                                        @endif )</span>
                                </div>
                                <div
                                    class="d-flex align-items-center gap-12 course-duration d-flex align-items-center gap-12">
                                    <h5>{{ minutes_to_hours($data['course']->course_duration) }}</h5>
                                    <div class="bulet-rouned"></div>
                                    <span>{{ @$data['course']->lessons->count() }}
                                        {{ ___('frontend.Lesson') }} </span>
                                </div>
                            </div>
                        </div> -->
                        <!-- <p class="course_description"><?= $data['course']->short_description ?></p> -->

                        <!-- course details tab  -->
                        
                        <div class="collegeNav mb-5">
                            <ul class=" course-details-tabs mt-2 d-flex" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="Overview-tab" data-bs-toggle="tab"
                                    data-bs-target="#Overview" type="button" role="tab" aria-controls="Overview"
                                    aria-selected="true">
                                    <!-- <i class="ri-dashboard-line"></i> -->
                                    <!-- <span>{{ ___('frontend.Overview') }}</span> -->
                                    <span>College Info</span></button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Curriculum-tab" data-bs-toggle="tab" data-bs-target="#Curriculum" type="button" role="tab" aria-controls="Curriculum"
                                        aria-selected="false">
                                        <!-- <i class="ri-file-list-line"></i> -->
                                        <!-- <span>{{ ___('frontend.Curriculum') }}</span> -->
                                        <span>Courses</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Admissions-tab" data-bs-toggle="tab"
                                        data-bs-target="#Admissions" type="button" role="tab"
                                        aria-controls="Admissions" aria-selected="false">
                                        <!-- <i class="ri-user-2-line"></i> -->
                                        <!-- <span>{{ $data["user_type"] }}</span> -->
                                        <span>Admissions</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Placements-tab" data-bs-toggle="tab" data-bs-target="#Placements"
                                        type="button" role="tab" aria-controls="Placements" aria-selected="false">
                                        <span>Placements</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Review-tab" data-bs-toggle="tab"   data-bs-target="#Review" type="button" role="tab"     aria-controls="Review" aria-selected="false">
                                        <span>Reviews</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Campus-tab" data-bs-toggle="tab" data-bs-target="#Campus"
                                    type="button" role="tab" aria-controls="Campus" aria-selected="false">
                                    <span>Campus</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Scholarship-tab" data-bs-toggle="tab" data-bs-target="#Scholarship"
                                    type="button" role="tab" aria-controls="Scholarship" aria-selected="false">
                                    <span>Scholarship</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Gallery-tab" data-bs-toggle="tab"  data-bs-target="#Gallery" type="button" role="tab" aria-controls="Gallery" aria-selected="false">
                                        <span>Gallery</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Q&A-tab" data-bs-toggle="tab" data-bs-target="#Q&A"
                                    type="button" role="tab" aria-controls="Q&A" aria-selected="false">
                                    <span>Q&A</span>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="Blog-tab" data-bs-toggle="tab" data-bs-target="#Blog"
                                    type="button" role="tab" aria-controls="Blog" aria-selected="false">
                                    <span>Blog & News</span>
                                    </button>
                                </li>
                            </ul>
                        </div>

                        <!--------- START:: All College/ Institute / University ---------------->
                        <div class="tab-content w-100" id="myTabContent">

                            <!-- College Info section -------------->
                            <div class="tab-pane fade show active college-info" id="Overview" role="tabpanel"
                                aria-labelledby="Overview-tab">
                                <div class="block box">
                                    <h2 class="course-details-title">IIM Indore at a Glance</h2>
                                    <p  style="color:black;">
                                    With the objectives of imparting high quality management education and training, the Department of Higher Education, Ministry of Education, Government of India established Indian Institute of Management Indore as Institutions of Excellence. These Institutions are recognized as premier management institutions, comparable to the best in the world for teaching, research and interaction with industries.
                                    </p>
                                    <p>Established in 1996, Indian Institute of Management Indore (IIM Indore) has been a leader in the field of management education, interfacing with the industry, government and PSUs. It is promoted and nurtured by the Ministry of Education, Government of India and is an institute of national importance under the Indian Institutes of Management Act 2017.Situated atop a scenic hillock, the 193 acre campus of IIM Indore provides an ideal backdrop for contemplative learning. IIM Indore has the latest in teaching aids, rich learning resources, a strong IT backbone, state-of-the-art sports complex and hostels as well as contemporary infrastructure.</P>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title">Mission</h2>
                                    <p>IIM Indore seeks to be a contextually-relevant business school with world-class
                                    academic standards that develops socially-conscious managers, leaders and entrepreneurs. IIM Indore is committed to:<br>
                                    •Excellence in management education, research, and training<br>
                                    • Use of contemporary participant-centric pedagogies and teaching methods<br>
                                    •A presence in emerging segments of management education<br>
                                    </p>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title">Academic Programmes</h2>
                                    <ul>
                                        <li><a href="">Post Graduate Programme in Management (PGP)</a></li>
                                        <li><a href="">Executive Post Graduate Programme in Management (EPGP)</a></li>
                                        <li><a href="">Fellow Programme in Management (FPM)</a></li>
                                        <li><a href="">Post Graduate Programme in Human Resource Management (PGP-HRM)</a></li>
                                        <li><a href="">Post Graduate Programme in Management for Working Executives (PGPMX)  in Mumba</a></li>
                                        <li><a href="">Executive Fellow Programme in Management (EFPM)</a></li>
                                        <li><a href="">Five Year Integrated Programme in Management (IPM)</a></li>
                                        <li><a href="">Executive Fellow Programme in Management and Governance (EFPMG)</a></li>
                                    </ul><br>
                                    <p>
                                        Accredited by Association of MBAs, London (AMBA—UK based accreditation agency), the Post Graduate Programme (PGP) in Management at IIM Indore is a two-year, full-time, residential programme. It is also recognized by the Association of Indian Universities and is considered equivalent to the M.B.A. Degree.<br>
                                        IIM Indore offers interdisciplinary learning and research in its academic programmes by providing exposure to a format which integrates data, information, tools and techniques, perspectives and concepts, from various basic disciplines aimed at advancing fundamental understanding to solve real life problems.<br>
                                        IIM Indore is one of the fastest growing institutions in India today. For lIM Indore, last few years of its growth have proved to be the most rewarding years in terms of international expansion, introduction of new programmes, infrastructure facilities, strengthening of manpower etc.
                                        part from the above mentioned academic programmes, IIM Indore also offers Executive Education .
                                    </p>
                                </div>
                            </div>

                            <!-- Courses Section ----------------curriculam -->
                            <div class="tab-pane fade pb-5" id="Curriculum" role="tabpanel" aria-labelledby="Curriculum-tab">
                                <div class="block box">
                                    <h2 class="course-details-title ">Indian Institute Of Management–Indore Courses and Fees 2024</h2>
                                    <div class="courses-details">
                                        <div class="courses-detail-overview">
                                            <div>The Greater Noida Institute of Technology fees for the offered courses range for the candidates depending onvarious factors such as popularity of courses, level of degree and more. The courses are offered to interestedcandidates at the undergraduate as well as postgraduate levels. These courses are offered in the stream ofengineering, management and computer applications. Some of the popular courses in the GNIOT Greater Noida courseslist are B.Tech, BBA, BCom BSc Nursing, MTech, MBA and MCA. All the courses at the institution are offered inregular, offline mode. There are various scholarships also available to the students to waive the Greater NoidaInstitute of Technology fees. The duration of the B.Tech courses is 4 years (3 years for lateral entry) at GreaterNoida Institute of Technology and the duration of PG courses is 2 years.<span id="dots">...</span><span id="more">The GNIOT Greater Noida fees for various courses range between Rs 1,70,000 to Rs 7,38,000. To get moreinformation about the Greater Noida Institute of Technology courses and fees details, refer to the table given below<h3 class="course-details-title ">Indian Institute Of Management–Indore Courses & Fee Structure 2024</h3>
                                            <div class="scrollTable">
                                                <table>
                                                    <thead>
                                                        <tr>
                                                            <th>Courses</th>
                                                            <th>Duration</th>
                                                            <th>Total Fees</th>
                                                            <th>Eligibility</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>BTech</td>
                                                            <td>4 Year(8 Semesters)</td>
                                                            <td>6,07,000</td>
                                                            <td>Class 12 in PCM with at least 45% marks (40% for SC/ST)</td>
                                                        </tr>
                                                        <tr>
                                                            <td>BBA</td>
                                                            <td>3 Years (6 semesters)</td>
                                                            <td>Rs 2,76,200</td>
                                                            <td>Class 12 with at least 45% marks</td>
                                                        </tr>
                                                        <tr>
                                                            <td>B.Com</td>
                                                            <td>3 Years (6 semesters)</td>
                                                            <td>Rs 1,70,000</td>
                                                            <td>Class 12 in a relevant stream</td>
                                                        </tr>
                                                        <tr>
                                                            <td>BSc Nursing</td>
                                                            <td>4 Years (8 semesters)</td>
                                                            <td>Rs 5,16,200</td>
                                                            <td>Class 12 in Physics, Mathematics, and, Chemistry/Biology/Biotech with at least 45% (40% marks for SC/ST)</td>
                                                        </tr>
                                                        <tr>
                                                            <td>BCA</td>
                                                            <td>3 Years (6 semesters)</td>
                                                            <td>Rs 2,76,200</td>
                                                            <td>Class 12 with at least 45% marks (33% for SC/ST) with Mathematics as a compulsory subject</td>
                                                        </tr>
                                                        <tr>
                                                            <td>PGDM</td>
                                                            <td>2 Years (4 semesters)</td>
                                                            <td>Rs 7,38,000</td>
                                                            <td>Graduation of a minimum of 3 years with at least 50% for the general category and 45% for SC/ST</td>
                                                        </tr>
                                                        <tr>
                                                            <td>MBA</td>
                                                            <td>2 Years (4 semesters)</td>
                                                            <td>Rs 3,55,500</td>
                                                            <td>BBA or equivalent UG degree</td>
                                                        </tr>
                                                        <tr>
                                                            <td>MCA</td>
                                                            <td>2 Years (4 semesters)</td>
                                                            <td>Rs 2,45,740</td>
                                                            <td>BCA or Bachelor's degree in CSE with at least 50% (45% for SC/ST)</td>
                                                        </tr>
                                                        <tr>
                                                            <td>MTech</td>
                                                            <td>2 Years (4 semesters)</td>
                                                            <td>	Rs 1,35,000</td>
                                                            <td>BE/BTech with at least 60%</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div></span>
                                    </div>
                                    <div class="show-less">
                                        <span onclick="myFunction()" id="myBtn">Show More</span>
                                    </div>
                                </div>
                            </div>
                            <!--End-of course tab  -->
                        </div>

                            <!-- Admissions Section ---------------------->
                            <div class="tab-pane fade pb-5" id="Admissions" role="tabpanel" aria-labelledby="Placements-tab">
                                <div class="block box">
                                    <h2 class="course-details-title">IIM Indore Admissions 2024</h2>
                                    <div class="courses-details">
                                        <span>
                                        <p>IIM Indore admission 2024 has started and the online application form has opened. The last date to apply for admission is January 15, 2024. IIM Indore admission 2024 is done through national-level entrance exams. The flagship IIM Indore course includes PGP (postgraduate programme in Management) to which admission is done through CAT scores followed by a personal interview round. Other courses offered by IIM Indore include EPGP, IPM, DPM, EDPM, EDPMG, PGPMX, etc. IIM Indore selection to these courses is done based on CAT/ GMAT/ GRE scores. </p>
                                            <p>IIM Indore admission to the PGP and other programmes (except IPM and EPGP) is strictly based on CAT scores for domestic students and GMAT/ GRE scores for international students. All the applicants are required to go through the personal interview round followed by these entrance exams. The final IIM Indore selection is based on composite scores of entrance exams + personal interview round. </p>
                                            <p>Admission to the IPM course at IIM Indore is done on the basis of the IIM Indore Aptitude Test (IPMAT) followed by personal interview and does not require CAT scores. Meanwhile, EPGP admission doesn't require any entrance tests. For the IIM Indore PI round, different programs give varying weightage to different components of the assessment. For example, PGP-HRM emphasizes HR-related skills in PI, and EPGP focuses heavily on work experience.</p>
                                        </span>
                                    </div>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title ">Table of Contents</h2>
                                    <div class="collegeDetails_contentBox mt-2">
                                        <ul class="d-flex">
                                            <li><a href="">IIM Indore Admissions 2024</a></li>
                                            <li><a href="">IIM Indore Admission Dates 2024</a></li>
                                            <li><a href="">IIM Indore Admission Process 2024</a></li>
                                            <li><a href="">IIM Indore PG Admission 2024</a></li>
                                            <li><a href="">IIM Indore Seat Reservation 2024</a></li>
                                            <li><a href="">IIM Indore Selection Criteria 2024</a></li>
                                            <li><a href="">How to prepare for IIM Indore WAT-PI after CAT 2023?</a></li>
                                            <li><a href="">How to get admission in IIM Indore without CAT?</a></li>
                                            <li><a href="">How to get admission in IIM Indore after class 12?</a></li>
                                            <li><a href="">IIM Indore Application Process 2024</a></li>
                                            <li><a href="">IIM Indore Application Fees</a></li>
                                            <li><a href="">IIM Indore CAP 2024</a></li>
                                            <li><a href="">FAQs about IIM Indore Admission</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <!-- Admission Date -->
                                <div class="block box">
                                    <h2 class="course-details-title">IIM Indore Admission Dates 2024</h2>
                                    <div class="courses-detail-overview">
                                    <!-- <span id="content">...</span><span id="show"> -->
                                        <div class="admission-dates">
                                            <p><strong>IIM Indore Admission Dates</strong></p>
                                            <!-- <span id="content">...</span><span id="show"> -->
                                            <div class="scrollTable">
                                                <table style="width:100%;">
                                                    <tbody>
                                                        <tr>
                                                            <th>Events</th>
                                                            <th>Date</th>
                                                        </tr>
                                                        <tr>
                                                            <td>Registration Start Date</td>
                                                            <td>November 30, 2023</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Last Date To Fill Application Form</td>
                                                            <td>January 15, 2024</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <span id="content">...</span><span id="show">
                                            <p class=" pt-4"><strong>IIM Indore Admission Dates Through CAT</strong></p>
                                            <div class="scrollTable">
                                                <table style="width:100%;">
                                                    <tbody>
                                                        <tr>
                                                            <th>Events</th>
                                                            <th>Date</th>
                                                        </tr>
                                                        <tr>
                                                            <td>Registration Start Date</td>
                                                            <td>August 2024</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Last Date To Fill Application Form</td>
                                                            <td>September 2024</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Application Form Correction Date</td>
                                                            <td>September 2024</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Admit Card</td>
                                                            <td>October 2024</td>
                                                        </tr>
                                                        <tr>
                                                            <td>CAT Entrance Test Date </td>
                                                            <td>November 24, 2024</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Result Date</td>
                                                            <td>	January 2025</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <p class=" pt-4"><strong>IIM Indore Admission Dates Through GMAT</strong></p>
                                            <div class="scrollTable">
                                                <table style="width:100%;">
                                                    <tbody>
                                                        <tr>
                                                            <th>Events</th>
                                                            <th>Date</th>
                                                        </tr>
                                                        <tr>
                                                            <td>Registration Start Date</td>
                                                            <td>August 2024</td>
                                                        </tr>
                                                        <tr>
                                                            <td>Last Date To Fill Application Form</td>
                                                            <td>September 2024</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div></span>
                                        </div>
                                    </div>
                                    <div class="show-less">
                                    <span onclick="showMore()" id="clickMe">Show More</span>
                                        <!-- <span onclick="showMore()" id="clickMe">Show More</span> -->
                                    </div>
                                </div>
                                <!-- admission Process -->
                                <div class="block box" >
                                    <h2 class="course-details-title">IIM Indore Admission Process 2024</h2>
                                    <div class="courses-detail-overview">
                                        <p>IIM Indore admission is offered to postgraduate programmes like EPGP, IPM, DPM, EDPM, EDPMG, PGPMX, etc. These courses are provided in full-time mode. IIM Indore PGP admission is done on the basis of CAT scores for domestic students and GMAT scores for international students. Candidates also have to appear for a personal interview round for selection. IIM Indore admission to the IPM course is done on the basis of IPMAT, and EPGP course doesn't require any standardized tests. Admission to other courses at IIM Indore is done on the basis of CAT/ GMAT/ GRE followed by a personal interview round.</p>
                                        <p>IIM Indore admission process includes several steps such as registration on the official website, filling out the application form, appearing for the exam, and others.</p>
                                        <p><strong>Step 1:</strong>
                                        IIM Indore admission registration</p>
                                        <p><strong>Step 2: </strong>IIM Indore admission registration</p>
                                        <p><strong>Step 3:</strong> Filling out the application form for IIM Indore/ CAT/ GMAT/ GRE</p>
                                        <p><strong>Step 4:</strong> Appearing for the entrance exam.</p>
                                        <p><strong>Step 5:</strong> Release of category wise merit list based on final composite score</p>
                                        <p><strong>Step 6:</strong> Release of provisional admission offers.</p>
                                        <p><strong>Step 8:</strong> Payment of IIM Indore admission fee to confirm the seats.</p>
                                        <!-- <p><strong>Step 7:</strong> IIM Indore admission registration</p> -->
                                    </div>
                                </div>
                            </div>
                            <!--Admissions Section  -->

                            <!-- Placements section ------------------->
                            <div class="tab-pane fade" id="Placements" role="tabpanel" aria-labelledby="Placements-tab">
                                <!-- <div class="course-tab-widget">
                                    <h3 class="course-details-title">Placements</h3>
                                </div> -->
                                <div class="block box">
                                    <h2 class="course-details-title">IIM Indore Placement Overview</h2>
                                    <p>IIM Indore has recently made the announcement of the 100% completion of IIM Indore placements 2023. This year, the institute has made a tremendous rise in placing students with lucrative packages. IIM Indore has made a 132.6% rise in the highest package. The college also invited new recruiters in placement drive 2023, including Ambit Capital, ASK Asset & Wealth Management, Axis Bank, Bank Of America, Barclays, BlackRock, CITI Bank, Credit Suisse, D.E. Shaw, Delhivery, etc. IIM Indore placement highlights 2023 for PGP-IPM have also been published. On the other hand, the institute has released the detailed IIM Indore placement report 2023 for its PGP-HRM and EPGP programmes.</p>
                                    <p>In addition, IIM Indore has released the IIM Indore summer placement report for PGP-HRM and EPGP. Check out the IIM Indore placement data 2023 in the section below.</p>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title">Table of Contents</h2>
                                    <div class="collegeDetails_contentBox mt-2">
                                        <ul class="d-flex">
                                            <li><a href="">IIM Indore Admissions 2024</a></li>
                                            <li><a href="">IIM Indore Admission Dates 2024</a></li>
                                            <li><a href="">IIM Indore Admission Process 2024</a></li>
                                            <li><a href="">IIM Indore PG Admission 2024</a></li>
                                            <li><a href="">IIM Indore Seat Reservation 2024</a></li>
                                            <li><a href="">IIM Indore Selection Criteria 2024</a></li>
                                            <li><a href="">How to prepare for IIM Indore WAT-PI after CAT 2023?</a></li>
                                            <li><a href="">How to get admission in IIM Indore without CAT?</a></li>
                                            <li><a href="">How to get admission in IIM Indore after class 12?</a></li>
                                            <li><a href="">IIM Indore Application Process 2024</a></li>
                                            <li><a href="">IIM Indore Application Fees</a></li>
                                            <li><a href="">IIM Indore CAP 2024</a></li>
                                            <li><a href="">FAQs about IIM Indore Admission</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title">IIM Indore Placements 2023</h2>
                                    <p>IIM Indore witnessed a 100% placement rate this year. Students are placed in various sectors, including real estate, FMCG, consulting firms, BSFI, consumer foods, healthcare, logistics & manufacturing, etc. The IIM Indore placement report 2023 is shown below: </p>
                                    <p>
                                        <table style="width:100%;">
                                            <tbody>
                                                <tr>
                                                    <th>Particulars</th>
                                                    <th>Data</th>
                                                </tr>
                                                <tr>
                                                    <td>New Recruiters</td>
                                                    <td>80</td>
                                                </tr>
                                                <tr>
                                                    <td>Number of recruiters</td>
                                                    <td>160</td>
                                                </tr>
                                                <tr>
                                                    <td>Average package</td>
                                                    <td>Rs 30.21 LPA</td>
                                                </tr>
                                                <tr>
                                                    <td>Median package</td>
                                                    <td>Rs 27.2 LPA</td>
                                                </tr>
                                                <tr>
                                                    <td>Increase in Highest CTC</td>
                                                    <td>132.6%</td>
                                                </tr>
                                                <tr>
                                                    <td>Increase in Average CTC</td>
                                                    <td>20.8%</td>
                                                </tr>
                                                <tr>
                                                    <td>Top recruiters</td>
                                                    <td>BCG, Deloitte India, Acuvon Consulting, Aspect Ratio,  Accenture Strategy, Avalon Consulting, Bain & Company, Deloitte USI, Everest Group, etc.</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </p>
                                </div>
                            </div>

                            <!-- Review SECTION ------------------------>
                            <div class="tab-pane fade" id="Review" role="tabpanel" aria-labelledby="Review-tab">
                                <!-- End-of course tab review  -->
                                <div class="block box">
                                    <div class="d-flex reviewTitle">
                                        <h2 class="pb-4">Average rating of this institute</h2>
                                        <div class="writeReview">
                                            <a href="{{url('review')}}">Write a Review</a>
                                            <!-- <button onclick="">Write a Review</button> -->
                                        </div>
                                    </div>
                                    <section class="block box review">
                                        <div class="row">
                                            <div class="col-lg-3 col-xl-3 col-12">
                                                <h3 class="course-details-title text-center">Overall Rating</h3>
                                                <div class="overAllrating">
                                                    <h3>4.6</h3>
                                                    <div class="reviewStar">
                                                        <div class="rating">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-regular fa-star"></i>
                                                        </div>
                                                        <!-- <div class="verified"> -->
                                                            <p class="verified text-center">verified</p>
                                                        <!-- </div> -->
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-5 col-xl-5 col-12 ">
                                                <div class="componentRatio">
                                                    <div class="row">
                                                        <p class="col-lg-7 col-xl-7 col-7">Course Content</p>
                                                        <p class="col-lg-5 c0l-xl-5 col-5">
                                                            <span>4.4</span>
                                                            <span class="ratingRatio">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </p>
                                                    </div>
                                                    <div class="row">
                                                        <p class="col-lg-7 col-xl-7 col-7">Faculty</p>
                                                        <p class="col-lg-5 c0l-xl-5 col-5">
                                                            <span>4.2</span>
                                                            <span class="ratingRatio">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </p>
                                                    </div>
                                                    <div class="row">
                                                        <p class="col-lg-7 col-xl-7 col-7"> Placement</p>
                                                        <p class="col-lg-5 c0l-xl-5 col-5">
                                                            <span>4.6</span>
                                                            <span class="ratingRatio">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </p>
                                                    </div>
                                                    <div class="row">
                                                        <p class="col-lg-7 col-xl-7 col-7">Campuse & Hostel</p>
                                                        <p class="col-lg-5 c0l-xl-5 col-5">
                                                            <span>4.4</span>
                                                            <span class="ratingRatio">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </p>
                                                    </div>
                                                    <div class="row">
                                                        <p class="col-lg-7 col-xl-7 col-7">Fees & Scholarships</p>
                                                        <p class="col-lg-5 c0l-xl-5 col-5">
                                                            <span>4.5</span>
                                                            <span class="ratingRatio">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-12 col-xl-4">
                                                <div class="review-image">
                                                    <img src="{{asset('/updated_frontend/images/college/review-image.webp')}}" alt="">
                                                </div>
                                            </div>
                                        </div>
                                    </section>
                                    
                                    <section class="block box reviews">
                                        <div class="allReviews">
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Priti Bathe</span> 
                                                            <span class="pipe">| Post Graduate Program in Management(PGP) - Batch 2024
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 16 Apr 2024</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.6</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placement 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campuse & Hostel 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 4<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/reviewBoy-image.avif')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Jay Yadav</span> 
                                                            <span class="pipe">| Electronics Engineering - Batch 2020
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 2 June 2020</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.6</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 3<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Khushi Gupta</span> 
                                                            <span class="pipe">| B.Tech [Bachelor of Technology] - Batch 2024
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 6 Feb 2024</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.8</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 5 <i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/reviewBoy-image.avif')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Kunal Jaiswal</span> 
                                                            <span class="pipe">| MCA [Master of Computer Application] - Batch 2022
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 16 july 2022</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.7</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 3<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Sitara prajapati</span> 
                                                            <span class="pipe">| Post Graduate Program in Management(PGP) - Batch 2019
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 03 may 2019</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.4</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 4 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 5<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Priti Bathe</span> 
                                                            <span class="pipe">| Post Graduate Program in Management(PGP) - Batch 2024
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 16 Apr 2024</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.6</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placement 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campuse & Hostel 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 4<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/reviewBoy-image.avif')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Jay Yadav</span> 
                                                            <span class="pipe">| Electronics Engineering - Batch 2020
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 2 June 2020</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.6</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 3<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Khushi Gupta</span> 
                                                            <span class="pipe">| B.Tech [Bachelor of Technology] - Batch 2024
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 6 Feb 2024</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.8</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 5 <i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/reviewBoy-image.avif')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Kunal Jaiswal</span> 
                                                            <span class="pipe">| MCA [Master of Computer Application] - Batch 2022
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 16 july 2022</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.7</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 5 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Faculty 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 3<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Sitara prajapati</span> 
                                                            <span class="pipe">| Post Graduate Program in Management(PGP) - Batch 2019
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 03 may 2019</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.4</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 4 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 5<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                            <div class="reviewCard">
                                                <div class="reviewDetailsHeader">
                                                    <div class="user-detail d-flex">
                                                        <img src="{{asset('/updated_frontend/images/college/review-profile.webp')}}" alt="">
                                                        <div class="userName">
                                                            <span class="black">Sitara prajapati</span> 
                                                            <span class="pipe">| Post Graduate Program in Management(PGP) - Batch 2019
                                                            </span>
                                                            <div class="userDate">
                                                                <span>Reviewed on 03 may 2019</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="verifiedSpan">
                                                        <span><i class="fa-solid fa-circle-check p3"></i>
                                                        Verified</span>
                                                    </div>
                                                </div>
                                                <div class="reviewRatingList">
                                                    <div class="reviewrating">
                                                        <div class="startRating d-flex">
                                                            <span style="color:black;margin-right: 7px;">4.4</span>
                                                            <span class="star">
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-solid fa-star"></i>
                                                                <i class="fa-regular fa-star"></i>
                                                            </span>
                                                        </div>
                                                        <span>Course Content 4 <i class="fa-solid fa-star"></i>
                                                        </span>
                                                        <span>Faculty 5 <i class="fa-solid fa-star"></i></span>
                                                        <span>Placements 4 <i class="fa-solid fa-star"></i></span>
                                                        <span>Campus & Hostel 3 <i class="fa-solid fa-star"></i></span>
                                                        <span>Fees & Scholarships 5<i class="fa-solid fa-star"></i></span>
                                                    </div>
                                                </div>
                                                <div class="reviewContent">
                                                    <div class="content contentData">
                                                        <p><strong>Placement: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Infrastructure: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Hostel: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                        <p><strong>Other: </strong>Lorem ipsum dolor sit amet consectetur adipisicing elit. Temporibus reiciendis cupiditate ipsum, asperiores cum porro odio expedita doloribus tempore doloremque totam fugit quod, quibusdam non, quae reprehenderit delectus facere quas?</p>
                                                    </div>
                                                    <div class="readMore mb-4 toggleButton">Read More</div>
                                                </div>
                                            </div>
                                        </div>
                                        <button id="loadMoreBtn">Load More Reviews</button>
                                    </section>
                                </div>

                            </div>

                            <!-- Campus section ---------------------- -->
                            <div class="tab-pane fade" id="Campus" role="tabpanel" aria-labelledby="Campus-tab">
                                <!-- <div class="course-tab-widget">
                                    <h3 class="course-details-title">Campus</h3>
                                </div> -->
                                <div class="block box">
                                    <h2 class="course-details-title ">Table of Contents</h2>
                                    <div class="collegeDetails_contentBox mt-2">
                                        <ul class="d-flex">
                                            <li><a href="">Sanskriti University Campus</a></li>
                                            <li><a href="">IIT Indore Facilities</a></li>
                                            <li><a href="">Sanskriti University Hostel & Fees Structure</a></li>
                                            <li><a href="">Images & Videos</a></li>
                                            <li><a href="">FAQs about Sanskriti University Mathura Campus</a></li>
                                            <li><a href="">Students Activities & Clubs</a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title ">IIM Indore Campus</h2>
                                    <p>Established in 1996, the IIIM Indore campus is spread across 193 acres that can easily accommodate 1500+ students every academic year. It is one of the fastest growing campuses of IIMs that has attracted students from all over the nation. Indian Institute of Management Indore Campus is regarded as one of the most beautiful campuses among all other management institution campuses in the nation. The institution has gained this title with all basic amenities and modern infrastructural support. All the requirements for the overall development and growth of the students are well catered by the concerned authorities of the institution.</p>
                                    <p>With approx 35 lecture theatres, 28 syndicate rooms, one computer lab, one finance lab, and 103 faculty cabins, the IIM Indore campus has tried to serve all the needs of its students. All the rooms are furnished well with proper air-conditioning and audio and visual support. The attached projectors enhance the learning experience of the students. Comfortable sitting arrangements help students to be at an ease and concentrate at gaining knowledge in a better way. The library or the IIM Indore Learning Center is another advantageous badge to the infrastructural part of the IIM Indore Campus. With more than a thousand books, reference materials and research papers, the Learning Centre is one the most attractive and calm place of the entire campus. It is a hybrid library with state-of-the-art technological applications. The Library is an active member of IIM Consortia & INDEST Consortia. Books for all section including management, business, economics, finance, politics, sports, etc are available in this IIM Indore Learning Center.</p>
                                    <p>IIM Indore also posses residential infrastructure that consists of both hostels for the students and quarters for the faculties of the institution. The institution also has hostel facilities with the provision of internet and mess services. The rooms are also a comfortable place where students can stay and get relaxed. Source of entertainment has also taken care off in the hostels of the IIM Indore campus. Sports complex and fitness centres are also available within the college campus.</p>
                                </div>
                                <div class="box block">
                                    <h2 class="course-details-title ">IIM Indore Facilities</h2>
                                    <div class="college_details-facilitys">
                                        <ul class="row">
                                            <li class="col-md-3 col-6 col-lg-2">
                                                <i class="fa-solid fa-graduation-cap"></i>
                                                <p>Academic Zone</p>
                                            </li>
                                            <li class="col-md-3 col-6  col-lg-2">
                                                <i class="fa-solid fa-graduation-cap"></i>
                                                <p>A/C</p>
                                            </li>
                                            <li class="col-md-3 col-6  col-lg-2">
                                                <i class="fa-solid fa-utensils"></i>
                                                <p>Canteen</p>
                                            </li>
                                            <li class="col-md-3 col-6  col-lg-2">
                                                <i class="fa-solid fa-graduation-cap"></i>
                                                <p>ATM</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                            <i class="fa-solid fa-house-user"></i>
                                                <p>Guest house</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-dumbbell"></i>
                                                <p>Gym</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                            <i class="fa-solid fa-hospital"></i>
                                                <p>Hospital</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-briefcase"></i>
                                                <p>Placementl</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-">
                                                <i class="fa-solid fa-house-medical"></i>
                                                <p>Medical Facilities</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-hotel"></i>
                                                <p>Girls Hostel</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-computer"></i>
                                                <p>Computer Lab</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                            <i class="fa-solid fa-flask"></i>
                                                <p>Planning lab</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-hotel"></i>
                                                <p>Scholarship</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-hotel"></i>
                                                <p>Auditorium</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-hotel"></i>
                                                <p>Counselling</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-book"></i>
                                                <p>Library</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-group-arrows-rotate"></i>
                                                <p>Grounds</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-mug-hot"></i>
                                                <p>Cafeteria</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-brands fa-yandex-international"></i>
                                                <p>International Center</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                                <i class="fa-solid fa-wifi"></i>
                                                <p>WiFi</p>
                                            </li>
                                            <li class="col-md-2 col-6  col-lg-2">
                                            <i class="fa-solid fa-people-group"></i>
                                                <p>Club</p>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="block box">
                                    <h2 class="course-details-title">Students Activities & Clubs</h2>
                                    <div class="overview">
                                        <span style="color:black">Innovation Club -</span>
                                        <p>Mirage, IPM’s Creative & Advertising Club, provides a platform for IPM participants to showcase their creativity & advertising skills. Mirage facilitates channelizing creative ideas for IPM participants to allow them to become agents of change, societal leaders & successful management professionals. Mirage conducts events, competitions & workshops to enhance creativity among IPM students & augment their advertising skills (digital, audio-visual, market based, merchandising, branding, etc.) Mirage also supports other clubs in their creative & promotional requirements. The club continuously focuses on the improving the participants’ skill sets with & enhances their innovative competence through supportive events and provides a platform to highlights current creative trends through the right balance of theoretical sessions, engaging events and practical exposure.</p>
                                        <span style="color:black">Entrepreneurship Club -</span>
                                        <p>The E-cell of Indian Institute of Management Indore is a student-run club which takes care of all the entrepreneurship related events on campus. Besides conducting events, it also organizes workshops and competitions in collaboration with VCs, partner Institutions and other pioneers in the industry. The objective of E-cell is to provide exposure to the students of IIM Indore who consider entrepreneurship as a career choice. This also serves as a platform to develop leadership trails, wealth for a wider and broader spectrum of stakeholders.</p>
                                        <span style="color:black">Quiz Club -</span>
                                        <p>The Quiz Club of IIM Indore is responsible for all the non-academic quizzing that happens on campus. IIM Indore has traditionally had a very good quizzing culture and the Quiz Club always looks to sustain and then build on that. This is done by constantly having quizzes on a variety of topics thus involving as many participants as possible in the events. The Quiz Club also encourages maximum participation from the institution in inter-institute quiz competitions that happen throughout the year like BT-Acumen, Tata Crucible, Nihilanth, etc. The quizzers from IIM Indore have a tradition of being the winners of the regional finals of TATA Crucible for 3 years in a row.</p>
                                    </div>
                                    <div class="student-activity">
                                        <h3 class="course-details-title">Live Projects</h3>
                                        <p>Consulting club offers opportunities to students to work with the industry professionals on real business cases.<br> This gives the students a live exposure to the business problems.</p>
                                        <h3 class="course-details-title">Events  </h3>
                                        <p>The club conducts consulting related events and quizzes to help students hone their consulting acumen.</p>
                                        <h3 class="course-details-title">Industry Workshops </h3>
                                        <p>The club invites industry leaders to share their experiences and interact with the students.</p>
                                        <p>In 2013-14 the Club continued to add depth to its core activities and innovated further by launching a new division. The inception of the Analytics division represents the foray of the club in the fast growing Analytics industry. The year also marked the launch of Analitique – a sponsored National Level Analytics Event.</p>
                                        <p>With a keen focus on professional standard live projects, the club also organized several consulting events and released white papers. The national level consulting event, NeetiShastra, was concluded with resounding success in December that was organized in association with the partners of Consult Clinic, the SME Consulting division of the club.</p>
                                    </div>
                                </div>
                                <!-- End-of course tab review  -->
                            </div>

                            <!-- Faculty Section ---------------- -->
                            <!-- <div class="tab-pane fade" id="Faculty" role="tabpanel" aria-labelledby="Faculty-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Faculty</h3>
                                </div>
                            </div> -->

                            <!-- Shcholarship Section -->
                            <div class="tab-pane fade" id="Scholarship" role="tabpanel" aria-labelledby="Scholarship-tab">
                                <div class="block box">
                                    <div class="scholarship">
                                        <h2 class="course-details-title">IIM Indore Scholarships</h2>
                                        <p>Students often wonder can I study in IIM Indore for free? Such students should know that IIM Indore extends financial aid to those students who are in need of financial assistance. The IIM Indore scholarship scheme is known as the Need Based Financial Assistance (NBFA). This IIM Indore scholarship is aimed to ensure that no student is deprived of higher education for financial reasons. Moreover, NBFA maintains the required diversity in the IIM Indore classrooms. NBFA is available to all enrolled PGP, PGP-HRM, and IPM students. The last date to apply for the IIM Indore NBFA scholarship is September 15, 2023. </p>
                                        <h3 class="course-details-title">IIM Indore Scholarship: Need Based Financial Assistance (NBFA)</h3>
                                        <div class="scrollTable mb-4">
                                            <table>
                                                <thead>
                                                    <tr>
                                                        <th>Family annual Income from all sources per annum</th>
                                                        <th>Any other condition which will be considered before sanction and can render the student ineligible</th>
                                                        <th>NBFA- educational loan interest reimbursement</th>
                                                        <th>Other benefits</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>Up to Rs 4,50,000</td>
                                                        <td>Ownership of any building not more than 600 sq. ft. anywhere in India (residential or commercial building), movable assets like FDs/ shares limit is Rs 10 lakh, and ownership of a car.</td>
                                                        <td>100% reimbursement of the interest on the educational loan amount actually withdrawn from the bank for paying the IIM Indore fees.</td>
                                                        <td>Rs 4,500 per month for 10 months towards mess fee reimbursement in a year. Or, Rs 1,000 per month is reimbursed for internet connection if not on campus due to the Covid19 situation.</td>
                                                    </tr>
                                                    <tr>
                                                        <td>Rs 4,50,001 to Rs  9,00,000</td>
                                                        <td>Ownership of a building not more than 600 sq. ft. Movable assets like FDs/shares limit is Rs 1lakh.</td>
                                                        <td>50% reimbursement of the interest on the educational loan amount actually withdrawn from thbank for paying the fees.</td>
                                                        <td>-</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div>
                                        <p>In addition, IIM Indore offers a merit-based award to a limited number of recipients of the NBFA based on their academic performance to encourage them to excel in their academic pursuits. The value of the award will be equal to the tuition fees for the year.</p>
                                        <div class="scrollTable">
                                            <table style="width:100%;">
                                                <thead>
                                                    <tr>
                                                        <th>Year</th>
                                                        <th>Number of Awards</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>PGP Year-1</td>
                                                        <td>3 awards</td>
                                                    </tr>
                                                    <tr>
                                                        <td>PGP Year-2</td>
                                                        <td>3 awards</td>
                                                    </tr>
                                                    <tr>
                                                        <td>PGP Year-1</td>
                                                        <td>1 award</td>
                                                    </tr>
                                                    <tr>
                                                        <td>PGP Year-2</td>
                                                        <td>1 award</td>
                                                    </tr>
                                                    <tr>
                                                        <td>PGP-HRM Year-1</td>
                                                        <td>1 award</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="box block">
                                    <h3 class="course-details-title">Indian Institute of Management (IIM Indore, IIM-A, IIMA, Indian Institute of Management Indore), Indore Scholarship Statistics 2023</h3>
                                    <div class="scrollTable">
                                        <table style="width:100%;">
                                            <thead>
                                                <tr>
                                                    <th>Gender</th>
                                                    <th>Male</th>
                                                    <th>Female</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><Strong>Total</Strong></td>
                                                    <td>40</td>
                                                    <td>12</td>
                                                </tr>
                                                <tr>
                                                    <td><Strong>OBC</Strong></td>
                                                    <td>0</td>
                                                    <td>0</td>
                                                </tr>
                                                <tr>
                                                    <td><Strong>SC</Strong></td>
                                                    <td>15</td>
                                                    <td>3</td>
                                                </tr>
                                                <tr>
                                                    <td><Strong>ST</Strong></td>
                                                    <td>9</td>
                                                    <td>6</td>
                                                </tr>
                                                <tr>
                                                    <td><Strong>Muslim</Strong></td>
                                                    <td>40</td>
                                                    <td>12</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Gallery Section -->
                            <div class="tab-pane fade" id="Gallery" role="tabpanel" aria-labelledby="Gallery-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Gallery</h3>
                                    <div class=" mb-4 row row-cols-1 row-cols-sm-3 row-cols-md-2 row-cols-lg-3 row-cols-xl-5">
                                        <div class=" mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-1.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-2.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-3.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-4.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-5.jpg')}}" alt="">
                                        </div>

                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-6.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-7.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-8.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-9.jpg')}}" alt="">
                                        </div>
                                        <div class="mb-4 col gallery">
                                            <img src="{{asset('/updated_frontend/images/college/gallery/img-10.jpg')}}" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Q&A Section --------------->
                            <div class="tab-pane fade" id="Q&A" role="tabpanel" aria-labelledby="Q&A-tab">
                                <div class="course-tab-widget">
                                    <h3 class="course-details-title">Q & A</h3>
                                    <div class="theme-according mb-24" id="accordion1">
                                      <div class="card">
                                        <div class="card-header pink_bg" id="four4">
                                          <h5 class="mb-0">
                                            <button class="btn btn-link text-white collapsed" data-bs-toggle="collapse" data-bs-target="#collapseFour0"                                      aria-expanded="false" aria-controls="four4">
                                              <span class="course-curriculum-title">Section 1</span>
                                              <span class="course-curriculum-lesson"> 3 Lesson - 2h </span>
                                            </button>
                                          </h5>
                                        </div>
                                        <div class="collapse" id="collapseFour0" data-parent="#accordion1">
                                          <div class="card-body">
                                            <ul class="course-video-lists">
                                              <i class="ri-play-circle-line"></i>Lesson 1</li>
                                              <li><i class="ri-question-line"></i>Quiz 1</li>
                                              <li><i class="ri-question-line"></i>Quiz 1</li>
                                            </ul>
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Blog & News ------------------ -->
                            <div class="tab-pane fade" id="Blog" role="tabpanel" aria-labelledby="Blog-tab">
                                <div class="block box">
                                    <h2 class="course-details-title">Letest News</h2>
                                    <div>
                                        <div class="row row-cols-md-1 row-cols-lg-2 row-cols-xl-2">
                                            <div class="col newsBlog">
                                                <div class="news-details d-flex">
                                                    <div class="news-image">
                                                        <img src="{{asset('/updated_frontend/images/about/Vision.jpg')}}" alt="">
                                                    </div>
                                                    <div class="news-title">
                                                    <h3 class="newsHeading">
                                                        <a href="">MBA Admission 2024: Check Last Date to Apply, Fees and Selection Process of Top B-Schools</a></h3>
                                                        <!-- <div class="news-def">IIM Indore is one of the top IIMs which has been ranked by various national and international bodies such as NIRF..... </div> -->
                                                        <div class="newsUpdateDate">
                                                            Apr 12, 2024 10:46 IST
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="news-view-share d-flex">
                                                    <span class="viewData">
                                                        <i class="fa-regular fa-eye"></i>
                                                        <label for="">189 View</label>
                                                    </span>
                                                    <span class="commentData">
                                                        <i class="fa-regular fa-message"></i>
                                                        <label for="">56 Comments</label>
                                                    </span>
                                                    <span class="shareData">
                                                        <i class="fa-regular fa-share-from-square"></i>
                                                        <label for="Share">2 Share</label>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col newsBlog">
                                                <div class="news-details d-flex">
                                                    <div class="news-image">
                                                        <img src="{{asset('/updated_frontend/images/about/University-Image.jpg')}}" alt="">
                                                    </div>
                                                    <div class="news-title">
                                                    <h3 class="newsHeading">
                                                        <a href="">MBA Admission 2024: Check Last Date to Apply, Fees and Selection Process of Top B-Schools</a></h3>
                                                        <!-- <div class="news-def">IIM Indore is one of the top IIMs which has been ranked by various national and international bodies such as NIRF..... </div> -->
                                                        <div class="newsUpdateDate">
                                                            Apr 12, 2024 10:46 IST
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="news-view-share d-flex">
                                                    <span class="viewData">
                                                        <i class="fa-regular fa-eye"></i>
                                                        <label for="">189 View</label>
                                                    </span>
                                                    <span class="commentData">
                                                        <i class="fa-regular fa-message"></i>
                                                        <label for="">17 Comments</label>
                                                    </span>
                                                    <span class="shareData">
                                                        <i class="fa-regular fa-share-from-square"></i>
                                                        <label for="Share">2 Share</label>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col newsBlog">
                                                <div class="news-details d-flex">
                                                    <div class="news-image">
                                                        <img src="{{asset('/updated_frontend/images/about/Vision.jpg')}}" alt="">
                                                    </div>
                                                    <div class="news-title">
                                                    <h3 class="newsHeading">
                                                        <a href="">MBA Admission 2024: Check Last Date to Apply, Fees and Selection Process of Top B-Schools</a></h3>
                                                        <!-- <div class="news-def">IIM Indore is one of the top IIMs which has been ranked by various national and international bodies such as NIRF..... </div> -->
                                                        <div class="newsUpdateDate">
                                                            dec 12, 2023 10:46 IST
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="news-view-share d-flex">
                                                    <span class="viewData">
                                                        <i class="fa-regular fa-eye"></i>
                                                        <label for="">345 View</label>
                                                    </span>
                                                    <span class="commentData">
                                                        <i class="fa-regular fa-message"></i>
                                                        <label for="">56 Comments</label>
                                                    </span>
                                                    <span class="shareData">
                                                        <i class="fa-regular fa-share-from-square"></i>
                                                        <label for="Share">19 Share</label>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="col newsBlog">
                                                <div class="news-details d-flex">
                                                    <div class="news-image">
                                                        <img src="{{asset('/updated_frontend/images/about/University-Image.jpg')}}" alt="">
                                                    </div>
                                                    <div class="news-title">
                                                    <h3 class="newsHeading">
                                                        <a href="">MBA Admission 2024: Check Last Date to Apply, Fees and Selection Process of Top B-Schools</a></h3>
                                                        <!-- <div class="news-def">IIM Indore is one of the top IIMs which has been ranked by various national and international bodies such as NIRF..... </div> -->
                                                        <div class="newsUpdateDate">
                                                            Apr 1, 2024 10:46 IST
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="news-view-share d-flex">
                                                    <span class="viewData">
                                                        <i class="fa-regular fa-eye"></i>
                                                        <label for="">19 View</label>
                                                    </span>
                                                    <span class="commentData">
                                                        <i class="fa-regular fa-message"></i>
                                                        <label for="">1 Comments</label>
                                                    </span>
                                                    <span class="shareData">
                                                        <i class="fa-regular fa-share-from-square"></i>
                                                        <label for="Share">2 Share</label>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <!--------- END:: All College/ Institute / University ----------->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End-of course-details-->

@endsection


@section('scripts')
    <script src="{{ asset('frontend/js/__course.js') }}" type="module"></script>
@endsection
