@extends('frontend.layouts.master')
@section('title', @$data['title'])
@section('content')

    <div class="container mb-5 ">
        <!-- Header -->
        <!-- <div class="careerHeader pt-4">
            <div class=" block box d-flex">
                <img src="{{ asset('/updated_frontend/images/Frontend/career/doctor.jpg') }}"alt="">
                <h2><a href="" style="color:#B90A0B">Doctor: Full Form, Courses, Fees, Eligibility, Admission, Duration, Colleges</a></h2>
            </div>
        </div> -->

        <div class="courseHeader mt-4">
            <div class="courseBanner">
                <img src="{{ asset('/updated_frontend/images/Frontend/courses/Btech.jpg') }}"alt="">
            </div>
            <div class="courseHeaderTitle">
                <div class="row">
                    <div class="col-lg-7 col-xl-7  col-md-12">
                        <h2 class=""><a href="" style="color:#B90A0B">BTech (Bachelor of Technology)</a></h2>
                    </div>
                    <div class="col-lg-5 col-xl-5  col-md-12">
                        <span class="courseCallback">
                            <a href="">
                                <i class="fa-solid fa-phone-volume"></i>
                                <span>Request a Callback </span>
                            </a>
                            <a href="">
                                <i class="fa-solid fa-comment-dots"></i>
                                <span>Chat to Counseller</span>
                            </a>
                        </span>
                    </div>
                </div>
            </div>
            <!-- <div class="courseHeaderTitle d-flex">
                <h2 class=""><a href="" style="color:#B90A0B">BTech (Bachelor of Technology)</a></h2>
                <span class="courseCallback">
                    <a href="">
                        <i class="fa-solid fa-phone-volume"></i>
                        <span>Request a Callback </span>
                    </a>
                    <a href="">
                        <i class="fa-solid fa-comment-dots"></i>
                        <span>Chat to Counseller</span>
                    </a>
                </span>
            </div> -->
        </div>

        <!-- Navbar  -->
        <nav class="menu-inner mb-5">
            <ul>
                <li><a class="activeStatus" href="#overview">Overview</a></li>
                <li><a href="#eligibility">Eligibility</a></li>
                <li><a href="#courseCurriculum">Course Curriculum</a></li>
                <li><a href="#fees">Fees</a></li>
                <li><a href="#careerOpportunity">Career Opportunity</a></li>
                {{-- <li><a href="#popularCollege">Popular Colleges</a></li> --}}
            </ul>
        </nav>

        <!-- content section -->
        <div class="row">
            <div class="col-lg-9 col-md-9 col">
                <section id="overview" class="pt-2 mb-5">
                    <!-- Overview / a1 content  -->
                    <div id="overview-a1" class="box">
                        <h2 class="fs-title">BTech Course Overview</h2>
                        <p>BTech is a four-year highly demanded undergraduate engineering course offering rewarding
                            prospects to students. The full form of BTech is Bachelor of Technology. Approximately 10 lakh
                            engineering students graduate annually in India from 2,500 engineering and 1,300 polytechnic
                            colleges. This course is available under BTech specializations such as BTech Computer Science
                            Engineering, Electronics and Communication Engineering, Civil Engineering, and Mechanical
                            Engineering to trending fields like Artificial Intelligence and Robotics. The first-year BTech
                            syllabus focuses on basic engineering subjects such as mathematics and physics, while the latter
                            semesters concentrate on the specialization chosen by the candidate.</p>
                        <p>BTech Admissions are done through merit and entrance exams. Some of the popular BTech entrance
                            exams include JEE Main, JEE Advanced, BITSAT, MHT CET, WBJEE, etc. As per the BTech eligibility
                            criteria, candidates are required to score at least 50% marks in class 12th from a recognized
                            board with Physics, Chemistry, and Mathematics as the compulsory subjects along with the
                            required marks in entrance examinations. Some of the top BTech colleges are IITs, NITs, BITS
                            Pilani, VIT Vellore, LPU, Siksha 'O' Anusandhan, etc. The average BTech course fee in India is
                            INR 5,00,000 - INR 9,00,000. </p>
                        <p>After completing the course, candidates are offered BTech Jobs as Computer Science Engineer,
                            Chemical Engineer, Research Associate, Mechanical Engineer, etc. The average BTech Salary in
                            India is INR 4,00,000 to INR 10,00,000 Per Annum. Some of the top BTech recruiters in India are
                            IBM Global Services, TATA Consultancy, Accenture Services, and HCL Technologies.</p>
                    </div>

                    <!-- Overview Table content -->
                    <div class="tableContent  box">
                        <h2 class="fs-title">Table of Contents</h2>
                        <ul class="d-flex" style="flex-wrap: wrap; ">
                            <li><a href="#overview-a1">BTech Course Overview</a></li>
                            <li><a href="#overview-a2">BTech Course Details</a></li>
                            <li><a href="#overview-a3">BTech Admission Process in India 2024</a></li>
                            <li><a href="#overview-a4">Direct BTech Admission Process Without Entrance Examinations</a></li>
                            <li><a href="#overview-a5">BTech Placements</a></li>
                            <li><a href="#overview-a6">BTech Career, Scope, and Job Profiles</a></li>
                        </ul>
                    </div>

                    <!-- a2 content -->
                    <div id="overview-a2" class="box">
                        <h2 class="fs-title">BTech Course Details</h2>
                        <p>Candidates can check major BTech highlights from the table below such as duration, eligibility,
                            entrance exams, fees, etc.</p>
                        <div class="scrollTable">
                            <table class="w-100">
                                <thead>
                                    <tr>
                                        <th>Particulars</th>
                                        <th>BTech Details</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>BTech full form&nbsp;</td>
                                        <td>Bachelor of Technology</td>
                                    </tr>
                                    <tr>
                                        <td>Level</td>
                                        <td>Undergraduate</td>
                                    </tr>
                                    <tr>
                                        <td>BTech Course Duration</td>
                                        <td>4 years</td>
                                    </tr>
                                    <tr>
                                        <td>Exam type</td>
                                        <td>Semester wise</td>
                                    </tr>
                                    <tr>
                                        <td>BTech Eligiblity Criteria</td>
                                        <td>Pass 50-55% marks in PCM&nbsp </td>
                                    </tr>
                                    <tr>
                                        <td>B.Tech Admission 2024</td>
                                        <td>Entrance exam and Counselling</td>
                                    </tr>
                                    <tr>
                                        <td>Entrance Exam</td>
                                        <td>JEE Main, JEE Advanced, WBJEE, BITSAT, VITEEE, KEAM, EAMCET&nbsp;</td>
                                    </tr>
                                    <tr>
                                        <td>Eligibility Criteria</td>
                                        <td>Complete class 12th from a recognized institute/board&nbsp;</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- a3 content -->
                    <div id="overview-a3" class="box">
                        <h2 class="fs-title">BTech Admission Process in India 2024</h2>
                        <div class="courseContent">
                            <p>Candidates who want to enroll in a BTech course need to follow the stages mentioned below.
                            </p>
                            <ol>
                                <li>For admission to BTech courses, it is mandatory for a candidate to appear for an
                                    entrance exam. Some of the national-level entrance exams are JEE Main for NITs, IIITs,
                                    GFTIs, and some private colleges. </li>
                                <li>To get admission to IITs, candidates have to appear for JEE Advanced.</li>
                                <li>Other state-level entrance exams such as WBJEE, KEAM, AP EAMCET, TS EAMCET, and MHT CET
                                    and university-level exams such as BITSAT, VITEEE, SRMJEEE are usually chosen by the
                                    candidates based on the choice of the college.</li>
                                <li>The BTech entrance exams usually occur every year in April, May, and June.</li>
                                <li>After the conclusion of the exams, the authorities conduct the counselling and seat
                                    allotment procedures. Candidates can select their chosen college based on the rank
                                    acquired by them and the availability of seats.</li>
                                <li>After the admission formalities are done, candidates will have to report to their
                                    respective colleges by paying the prescribed BTech fees.</li>
                            </ol>
                        </div>
                    </div>
                    <!-- a4 content -->
                    <div id="overview-a4" class="box">
                        <h2 class="fs-title">Direct BTech Admission Process Without Entrance Examinations</h2>
                        <div class="courseContent">
                            <p>Candidates who do not wish to appear for any exam but pursue a BTech can be admitted to their
                                desired institutions through a direct entry procedure. Access to direct BTech universities
                                can be done through Management Quota, NRI Quota, Lateral Entry, and Institute-Specific
                                Criteria. </p>
                            <ul class="mb-3 tableContent">
                                <li><strong>Management Quota: </strong>Some private engineering colleges like Delhi
                                    Technical Campus (DTC), Thapar Institute of Engineering and Technology, etc. have a
                                    special quota called the Management Quota, which allows for direct entry to their
                                    courses. However, the fees for this quota are often higher compared to regular entry.
                                </li>
                                <li><strong>Lateral Entry: </strong>If you have a diploma in engineering or a related field,
                                    you may be eligible for lateral entry directly into the second year of the BTech
                                    program. Some of the colleges offering lateral entry direct admission are Adamas
                                    University and NMIMS. </li>
                            </ul>
                            <strong>Top BTech Colleges Offering Direct Admission in India</strong>
                            <p>Many top-notch colleges in India offer direct access to candidates willing to pursue BTech.
                                Some of them have been listed below.</p>
                            <div class="scrollTable">
                                <table class="w-100">
                                    <thead>
                                        <tr>
                                            <th>Vellore Institute of Technology (VIT), Vellore</th>
                                            <th>Manipal Institute of Technology (MIT), Manipal</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>SRM IST, Chennai</td>
                                            <td>Thapar Institute of Engineering and Technology, Patiala</td>
                                        </tr>
                                        <tr>
                                            <td>Birla Institute of Technology and Science (BITS), Pilani</td>
                                            <td>PES University, Bangalore</td>
                                        </tr>
                                        <tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- a5 content -->
                    <div id="overview-a5" class="box">
                        <h2 class="fs-title">BTech Placements</h2>
                        <div class="courseContent">
                            <p>B.Tech Placements in institutes like IITs and NITs have a very high rate. Some of the top
                                organizations taking part in the placement drive are Google, Microsoft, Adobe, Cisco,
                                Capgemini, Amazon, Flipkart, Accenture, etc. Some of the PSUs also take part in the
                                recruitment process such as BHEL, SAIL, GAIL, etc. We will discuss the BTech Placements for
                                private as well as government institutions here.</p>
                            <strong>BTech Placements in Private Colleges</strong>
                            <p>Some of the top BTech Placements offered in Private institutes have been listed in the table
                                below.</p>
                            <div class="scrollTable">
                                <table class="w-100">
                                    <thead>
                                        <tr>
                                            <th>College Name</th>
                                            <th>Average CTC</th>
                                            <th>Top Recruiters</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>ICT Mumbai Placements</td>
                                            <td>INR 5 - 17 LPA</td>
                                            <td>
                                                <ul class="mb-3 tableContent">
                                                    <li>L&T</li>
                                                    <li>Pidilite</li>
                                                    <li>BPL</li>
                                                    <li>Marico</li>
                                                    <li>Pepsico</li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>BITS Pilani Placements</td>
                                            <td>INR 11 - 38 LPA</td>
                                            <td>
                                                <ul class="mb-3 tableContent">
                                                    <li>Barclays</li>
                                                    <li>BigBasket Blend360</li>
                                                    <li>Cleartrip (Flipkart)</li>
                                                    <li>HDFC Life</li>
                                                    <li>GreyOrange</li>
                                                </ul>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- a6 content -->
                    <div id="overview-a6" class="box">
                        <h2 class="fs-title">BTech Career, Scope, and Job Profiles</h2>
                        <div class="courseContent">
                            <p>BTech is one of the most popular courses amongst students after completing Class 12th. It is
                                evident by the fact that millions of students appear for JEE and other top engineering
                                entrance exams every year. It offers a wide range of opportunities, thus increasing its
                                popularity amongst students. Graduates are hired across various domains such as KPO/Research
                                Analytics, and Accounting/Finance. The BTech degree is one of the most lucrative degrees in
                                India as it offers numerous career options and there is a huge demand for engineering
                                graduates. There are various jobs for BTech candidates in India as well as abroad. The types
                                of jobs that the BTech graduates get hired from are commonly Computer Science Engineer,
                                Automobile Engineer, Electrical Engineer, Robotics Engineer, Electrical Engineer, etc. </p>
                            <p>The Bachelor of Technology salary received by the graduates at the initial level is moderate.
                                To earn a moderate number, candidates need to be experienced after which the B Tech salaries
                                are beyond expectations. The average annual starting B Tech salary in India could fluctuate
                                between INR 3 LPA LPA to INR 6 LPA. Check some of the popular BTech career options given
                                below. </p>
                            <div class="scrollTable">
                                <table class="w-100">
                                    <thead>
                                        <tr>
                                            <th>Job Profile</th>
                                            <th>Job Description</th>
                                            <th>Average BTech Salary (Per Annum)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Automobile Engineer</td>
                                            <td>An automobile engineer uses CAD to design and develop new designs. Takes
                                                care of maintenance-related issues, supply chain management, and adjustment
                                                of mechanical systems.</td>
                                            <td>INR 2,00,000</td>
                                        </tr>
                                        <tr>
                                            <td>Biomedical Engineer</td>
                                            <td>They work with a wide range of medical, technical, and administrative staff.
                                                It also includes designing, developing, and testing medical equipment and
                                                devices.</td>
                                            <td>INR 3,00,000</td>
                                        </tr>
                                        <tr>
                                            <td>Civil Engineer</td>
                                            <td>They deal with the designing, development, and maintenance of small and
                                                large construction projects.</td>
                                            <td>INR 3,60,000</td>
                                        </tr>
                                        <tr>
                                            <td>Software Developer</td>
                                            <td>Designing, developing, implementation, testing, and maintenance of a
                                                software system. Write codes to develop a software resource and take care of
                                                its maintenance.</td>
                                            <td> INR 5,00,000</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </section>

                <section id="eligibility" class=" pt-2 mb-5">
                    <div class="box">
                        <h2 class="fs-title">Eligibility for B.Tech Course</h2>
                        <strong> Educational Qualifications:</strong>
                        <p>Prospective candidates should have completed their higher secondary education (10+2) from a
                            recognized board or institution. They must have studied Physics, Mathematics, and Chemistry (or
                            Biology) as core subjects during their 10+2 education.</p>
                        <strong>Minimum Aggregate Marks:</strong>
                        <p>Most institutions require candidates to have a minimum aggregate score in their 10+2
                            examinations. This aggregate score threshold may vary depending on the institution and the
                            specific B.Tech program. Typically, candidates are expected to have secured at least 50% to 60%
                            marks in their qualifying examination.</p>
                        <strong>Entrance Examinations:</strong>
                        <p>In addition to meeting the educational qualification criteria, candidates are often required to
                            clear national or state-level entrance examinations for admission to B.Tech programs. Some of
                            the commonly accepted entrance exams for B.Tech admission in India include JEE Main (Joint
                            Entrance Examination Main), JEE Advanced, BITSAT (Birla Institute of Technology and Science
                            Admission Test), and various state-level engineering entrance exams.</p>
                        <strong>Domicile Requirements (for State Quotas):</strong>
                        <p>In certain states, a percentage of seats in engineering colleges are reserved for candidates who
                            are residents of that state. Therefore, candidates seeking admission under state quotas may need
                            to fulfill specific domicile requirements.</p>
                        <strong>Special Criteria:</strong>
                        <p>Some institutions may have special eligibility criteria for certain B.Tech programs or reserved
                            categories such as SC/ST/OBC, differently-abled candidates, and so on. These criteria may
                            include relaxation in minimum qualifying marks or additional entrance tests</p>
                        <strong>Counseling Process:</strong>
                        <p>After clearing the entrance examination, candidates need to participate in counseling sessions
                            conducted by respective authorities or institutions. During counseling, candidates are allotted
                            seats based on their merit rank, preferences, and availability of seats.</p>
                        <p>It's important for prospective candidates to thoroughly research the specific eligibility
                            criteria and admission process of the institutions they are interested in, as requirements may
                            vary. Additionally, staying updated with the latest notifications and announcements from the
                            concerned authorities is crucial for a smooth admission process.</p>
                    </div>
                </section>

                <section id="courseCurriculum" class="pt-2 mb-5">

                    <!-- Courses content overview b1 -->
                    <div class="box" id="syllabus-b1">
                        <h2 class="fs-title">B Tech Course Curriculum and Subjects Overview</h2>
                        <div class="courseContent">
                            <p>The BTech syllabus and subjects contain core subjects, elective subjects, and lab subjects.
                                The BTech elective subjects may vary from one university to the other. B Tech syllabus is
                                designed for candidates who aim to invest themselves in the corporate field and core tech
                                and information industry. The B Tech subjects are simple and easy to understand. All the
                                years are divided into two consecutive semesters. Hence, candidates have to study the B Tech
                                syllabus for four years which is divided into eight semesters. Subjects such as Physics,
                                Mathematics, Chemistry, Mechanics, English, Electrical Technology, Engineering Drawing and
                                Graphics, Programming, Data Structures, etc, are common subjects in the BTech curriculum.
                            </p>
                            <ul class="mb-3 tableContent">
                                <strong>Quick Facts about BTech Syllabus and Subjects - </strong>
                                <li>B Tech course is a four-year course that deals with the field of engineering as well as
                                    technology.</li>
                                <li>If you're interested in pursuing a degree in technology, then BTech might be the right
                                    choice for you. BTech subjects cover specializations such as Information technology,
                                    digital electronics, Structural analysis, and many more. To pursue BTech, you need to
                                    complete your class 12th and appear in entrance exams such as JEE Mains or JEE Advanced.
                                </li>
                                <li>BTech syllabus and subjects offer almost 100 different specializations such as civil,
                                    mechanical, electrical, computer science, nuclear, biomedical, biotechnology, and so on.
                                    Each specialization focuses on different areas. You can choose the BTech subjects that
                                    interest you the most. </li>
                            </ul>
                        </div>
                    </div>

                    <!-- Table content for Course content -->
                    <div class="tableContent  box">
                        <h2 class="fs-title">Table Contents Course Curriculum</h2>
                        <ul class="d-flex" style="flex-wrap: wrap; ">
                            <li><a href="#syllabus-b1">B Tech Course Content and Subjects Overview</a></li>
                            <li><a href="#syllabus-b2">BTech Syllabus and Subjects 2024 Highlights</a></li>
                            <li><a href="#syllabus-b3">Semester Wise B Tech Syllabus (Yearly)</a></li>
                        </ul>
                    </div>

                    <!-- Courses content overview b2 -->
                    <div class="box" id="syllabus-b2">
                        <h2 class="fs-title">BTech Syllabus and Subjects 2024 Highlights</h2>
                        <div class="courseContent">
                            <p>Candidates can check the BTech subjects highlights from the table below.</p>
                            <div class="scrollTable">
                                <table class="w-100">
                                    <thead>
                                        <tr>
                                            <th>Particulars </th>
                                            <th>Details </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>Duration </td>
                                            <td>4 years</td>
                                        </tr>
                                        <tr>
                                            <td>Core subjects </td>
                                            <td>
                                                <ul class="mb-3 tableContent">
                                                    <li><strong>Computer Science- </strong>Circuit Theory & networks, Data
                                                        Structure and Algorithms, Computer Organization, etc.</li>
                                                    <li><strong>Biotechnology- </strong>Process Calculations and
                                                        Thermodynamics, Microbiology and Bioprocess Technology, Biochemistry
                                                        and Enzyme Technology</li>
                                                    <li><strong>Civil- </strong> Numerical techniques, Probability,
                                                        Statistics, Linear Programming, Geotechnical Engineering</li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Elective subjects </td>
                                            <td>
                                                <ul class="mb-3 tableContent">
                                                    <li>Robotics</li>
                                                    <li>Artificial Intelligence</li>
                                                    <li>Machine Learning</li>
                                                    <li>Autonomous Vehicles</li>
                                                    <li>Material Handling</li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Books </td>
                                            <td>
                                                <ul class="mb-3 tableContent">
                                                    <li>Introduction to Algorithms by Thomas H. Cormen</li>
                                                    <li>Superintelligence: Path, Dangers, Strategies by Nick Bostrom</li>
                                                    <li>The Soul of A New Machine by Tracy Kidder</li>
                                                </ul>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Common Subjects</td>
                                            <td>
                                                <ul class="mb-3 tableContent">
                                                    <li>Joy of Engineering</li>
                                                    <li>Communication and Professional Skills</li>
                                                    <li>Workshop Practice</li>
                                                    <li>Computing Fundamentals & C</li>
                                                    <li>World Civilizations</li>
                                                    <li>Data Structures</li>
                                                    <li>Writing Skills</li>
                                                </ul>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Courses content Syllabus b2 -->
                    <div id="syllabus-b3" class="box">
                        <h2 class="fs-title">Semester Wise B Tech Syllabus (Yearly)</h2>
                        <div class="courseContent">
                            <p>The BTech 1st Year subjects are the same for all the specializations and start varying from
                                the second year of the course. Hence candidates can check the Semester wise B Tech syllabus
                                from the following -</p>

                            <h2 class="fs-title-sub">BTech 1st Year Syllabus </h2>
                            <p>The BTech 1st Year subjects have been divided into semester 1 and semester 2 that has been
                                listed in the headings below -</p>

                            <strong>Bachelor of Technology Syllabus - Semester 1</strong>
                            <p>Candidates can check the semester wise BTech subjects from the pointers below.</p>
                            <ul class="mb-3">
                                <li>Joy of Engineering</li>
                                <li>Communication and Professional Skills</li>
                                <li>Workshop Practice</li>
                                <li>Computing Fundamentals & C</li>
                                <li>Chemistry</li>
                                <li>Mathematics 1</li>
                                <li>Physical 1</li>
                            </ul>
                            <strong>Bachelor of Technology Syllabus- Semester 2</strong>
                            <p>Candidates can check the semester wise BTech subjects from the pointers below.</p>
                            <ul class="mb-3">
                                <li>World Civilizations</li>
                                <li>Data Structures </li>
                                <li>Writing Skills</li>
                                <li>Environmental Studies</li>
                                <li>Mathematics 2</li>
                                <li>Physical 2</li>
                                <li>Basic Electrical and Electronic Practice</li>
                            </ul>
                            <h2 class="fs-title-sub">Bachelor of Technology 2nd Year Syllabus</h2>
                            <p>The semester wise BTech syllabus for second year has been divided into semester 3 and
                                semester 4 that has been listed in the headings below</p>
                            <ul class="mb-3">
                                <strong>Bachelor of Technology Syllabus- Semester 3</strong>
                                <li>Engineering Thermodynamics</li>
                                <li>Control Systems</li>
                                <li>Mathematics 3</li>
                                <li>Electrical Devices</li>
                                <li>Strength of Materials</li>
                                <li>Thermodynamics Lab</li>
                                <li>Control Systems Lab</li>
                            </ul>
                            <ul class="mb-3">
                                <strong>Bachelor of Technology Syllabus- Semester 4</strong>
                                <li>Data Structures</li>
                                <li>Digital Electronics</li>
                                <li>Mathematics 4</li>
                                <li>Microprocessors</li>
                                <li>Microprocessors Lab</li>
                                <li>Digital Electronics Lab</li>
                                <li>Theory of Machines</li>
                            </ul>
                            <h2 class="fs-title-sub">Bachelor of Technology 3rd Year Syllabus</h2>
                            <p>The semester wise BTech subjects for third year has been divided into semester 5 and semester
                                6 that has been listed in the headings below</p>
                            <ul class="mb-3">
                                <strong>Bachelor of Technology Syllabus- Semester 5</strong>
                                <li>Structural Analysis</li>
                                <li>Concrete Structures</li>
                                <li>Machine Design</li>
                                <li>Industrial Automation</li>
                                <li>Elective 1</li>
                                <li>Sensors and Instrumentation</li>
                                <li>Structural Analysis Lab</li>
                                <li>Industrial Automation Lab</li>
                            </ul>
                            <strong>Bachelor of Technology Syllabus- Semester 6</strong>
                            <ul class="mb-3">
                                <li>Hydraulics and Pneumatics</li>
                                <li>Elective 2</li>
                                <li>Analog Circuits</li>
                                <li>Transportation Engineering</li>
                                <li>Digital Signal Processing</li>
                                <li>Elective 3</li>
                                <li>Hydraulics Lab</li>
                                <li>Circuit Design Lab</li>
                            </ul>
                            <h2 class="fs-title-sub">BTech 4th Year Syllabus</h2>
                            <p>The semester wise BTech syllabus for the fourth year has been divided into semester 7 and
                                semester 8 that has been listed in the headings below</p>
                            <strong>Bachelor of Technology Syllabus- Semester 7</strong>
                            <ul class="mb-3">
                                <li>Elective 4</li>
                                <li>Elective 5</li>
                                <li>Elective 6</li>
                                <li>VLSI Technology</li>
                                <li>Power Electronics</li>
                                <li>Fundamentals of Machine Learning</li>
                                <li>Power Electronics Lab</li>
                                <li>Electives Lab</li>
                            </ul>
                            <strong>Bachelor of Technology Syllabus- Semester 8</strong>
                            <ul>
                                <li>Industrial Management</li>
                                <li>Open Elective</li>
                                <li>Dissertation</li>
                                <li>Industrial Project</li>
                                <li>Viva Voce</li>
                                <li>Internship</li>
                            </ul>
                        </div>
                    </div>
                </section>

                <!-- Course fees -->
                <section id="fees" class="pt-2 mb-5">
                    <div class="courseContent box">
                        <h2 class="fs-title">Fees Range for BTech </h2>
                        <strong>Government Engineering Colleges:</strong>
                        <p>
                        <ul>
                            <li>Tuition fees for B.Tech courses in government engineering colleges in India are generally
                                lower compared to private institutions due to government subsidies.</li>
                            <li>Annual tuition fees in government engineering colleges typically range from approximately
                                INR 10,000 to INR 50,000 for general category students.</li>
                            <li>However, fees may vary slightly based on the state and specific institutions.</li>
                        </ul>
                        </p>
                        <strong>Private Engineering Colleges:</strong>
                        <p>
                        <ul>
                            <li>Private engineering colleges in India often have higher tuition fees compared to government
                                colleges.</li>
                            <li>Annual tuition fees in private engineering colleges can vary widely, with average fees
                                ranging from approximately INR 50,000 to INR 2,00, 000 or more.</li>
                            <li>Fees may depend on factors such as the institution's reputation, infrastructure, faculty,
                                and facilities offered.</li>
                        </ul>
                        </p>
                        <strong>Prestigious/Private Universities:</strong>
                        <p>
                        <ul>
                            <li>Fees in prestigious universities or institutes and private deemed universities can be higher
                                compared to both government and private engineering colleges.</li>
                            <li>Annual tuition fees in prestigious universities may exceed INR 2,00,000 per annum.</li>
                            <li>These institutions often offer additional resources, modern infrastructure, and strong
                                industry connections, which contribute to the higher costs.</li>
                        </ul>
                        </p>
                        <strong>Scholarships and Financial Aid:</strong>
                        <p>
                        <ul>
                            <li>Many institutions in India offer scholarships and financial aid programs based on academic
                                merit, financial need, or other criteria.</li>
                            <li>These scholarships can significantly reduce the overall cost of education for eligible
                                students.</li>
                        </ul>
                        </p>
                        <strong>Additional Expenses:</strong>
                        <p>In addition to tuition fees, students may need to budget for other expenses such as registration
                            fees, examination fees, laboratory fees, library fees, transportation, accommodation, books,
                            study materials, and other living expenses.</p>
                    </div>
                </section>

                <!-- Popular college -->
                <section id="careerOpportunity" class="mb-5">
                    <div class="courseContent box">
                        <h2 class="fs-title">Career Opportunity for BTech</h2>
                        <!-- <strong>B.Tech In Mechanical Engineering</strong>
                    <ul>
                        <li><a href="">Systems Engineer</a></li>
                        <li><a href="">Applications Engineer</a></li>
                        <li><a href="">Plant Engineer</a></li>
                        <li><a href="">Renewable Energy Consultant</a></li>
                        <li><a href="">Manufacturing Engineer</a></li>
                        <li><a href="">Engineering Consultant </a></li>
                        <li><a href="">Mechatronics Engineer</a></li>
                        <li><a href="">Process Development Engineer</a></li>
                        <li><a href="">Design Engineer </a></li>
                        <li><a href="">Electro-Mechanical Engineer</a></li>
                        <li><a href="">Power Engineer </a></li>
                        <li><a href="">Packaging Engineer</a></li>
                        <li><a href="">Sales Engineer</a></li>
                        <li><a href="">Technical Content Writer</a></li>
                    </ul> -->
                        <table class="w-100 text-center">
                            <tr>
                                <td><a href="">Software Developer/Engineer</a></td>
                                <td><a href="">Systems Analyst</a></td>
                                <td><a href="">Data Scientist</a></td>
                                <td><a href="">Network Engineer</a></td>
                            </tr>
                            <tr>
                                <td><a href="">Database Administrator</a></td>
                                <td><a href="">IT Consultant</a></td>
                                <td><a href="">Project Manager</a></td>
                                <td><a href="">Cybersecurity Analyst</a></td>
                            </tr>
                            <tr>
                                <td><a href="">Artificial Intelligence Engineer</a></td>
                                <td><a href="">Machine Learning Engineer</a></td>
                                <td><a href="">Robotics Engineer</a></td>
                                <td><a href="">Embedded Systems Engineer</a></td>
                            </tr>
                            <tr>
                                <td><a href="">Cloud Solutions Architect</a></td>
                                <td><a href="">Web Developer</a></td>
                                <td><a href="">Mobile Application Developer</a></td>
                                <td><a href="">Quality Assurance Engineer</a></td>
                            </tr>
                            <tr>
                                <td><a href="">Technical Support Engineer</a></td>
                                <td><a href="">Electronics and Communication Engineer</a></td>
                                <td><a href="">Chemical Engineer</a></td>
                                <td><a href="">Environmental Engineer</a></td>
                            </tr>
                            <tr>
                                <td><a href="">Biomedical Engineer</a></td>
                                <td><a href="">Aeronautical Engineer</a></td>
                                <td><a href="">Agricultural Engineer</a></td>
                                <td><a href="">Marine Engineer</a></td>
                            </tr>
                            <tr>
                                <td><a href="">Energy Systems Engineer</a></td>
                                <td><a href="">Automation Engineer</a></td>
                                <td><a href=""></a></td>
                                <td><a href=""></a></td>
                            </tr>
                        </table>
                    </div>
                </section>

            </div>
            <div class="col-lg-3 col col-md-3">
                <h2>Ad and Blog</h2>
            </div>
        </div>

    </div>

@endsection

<script></script>
<!-- @section('scripts')
        <script src="{{ asset('frontend/js/__filter.js') }}"></script>
@endsection -->
