@extends('panel.student.layouts.master')
@section('title', @$data['title'])
@section('content')
<!-- My Profile S t a r t -->
<section class="my-profile-area">
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two d-flex align-items-center justify-content-between flex-wrap mb-20">
                <h2 class="title font-600">{{ @$data['title'] }}</h2>
                <span class="action-success" id="copyButton" data-url="{{ route('share.profile', ['username' => @$data['student']->user->username]) }}">
                    <i class="ri-file-copy-line"></i>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="my-profile-wrapper">
                <div class="col-xl-12">
                    <div class="small-tittle-two border-bottom d-flex align-items-center justify-content-between flex-wrap gap-10 mb-20 pb-8">

                        <div class="country d-flex align-items-center ">
                            <i class="ri-book-open-line"></i>
                            <span class="country text-title font-600 ml-10">{{ ___('student.Educations') }}</span>
                        </div>
                        <button class="btn-primary-outline" onclick="mainModalOpen(`{{ route('student.addInstitute') }}`)"><i class="ri-add-line"></i> {{ ___('student.add new') }}</button>
                    </div>
                </div>
                <div class="row">
                    @if (@$data['student']->education)
                    @foreach (@$data['student']->education as $key => $institute)
                    <div class="col-xl-12">
                        <div class="single-education mb-30 d-flex justify-content-between align-items-start">

                            <div class="education-cap">
                                <h4 class="text-18 text-tile mb-15">
                                    <a href="#">
                                        {{ @$institute['name'] }}
                                    </a>
                                </h4>
                                <p class="pera text-primary mb-6">
                                    {{ @$institute['degree'] }} - {{ @$institute['program'] }}

                                </p>
                                <p class="pera mb-20">
                                    {{ date('M y', strtotime(@$institute['start_date'])) }} -
                                    @if (@$institute['current'])
                                    {{ ___('student.Continue') }}
                                    @else
                                    {{ date('M y', strtotime(@$institute['end_date'])) }}
                                    @endif
                                </p>
                                <p class="pera mb-6">
                                    <?= @$institute['description'] ?>
                                </p>
                                @if (!empty($institute['certificate_image_id']))
                                <p class="pera mb-6">
                                    @php
                                    $upload = \App\Models\Upload::find(@$institute['certificate_image_id']);
                                    @endphp
                                    @if ($upload)
                                    <img src="{{ showImage($upload->original,'default-1.jpeg') }}" alt="Certificate Image" style="max-width: 100%; height: auto;">
                                    @endif
                                </p>
                                @endif
                            </div>



                            {{-- Button --}}
                            <div class="d-flex gap-10">
                                <button class="btn text-primary border-0 p-0 action-success" onclick="mainModalOpen(`{{ route('student.edit.institute', [$key]) }}`)"><i class="ri-pencil-line"></i></button>
                                <button class="btn text-tertiary border-0 p-0 action-danger" onclick="destroyFunction(`{{ route('student.delete.institute', [$key]) }}` )"><i class="ri-delete-bin-line"></i></button>
                            </div>
                        </div>
                    </div>
                    @endforeach
                    @endif
                    <!-- Educations end -->
                </div>
                <!-- Aadhaar and PAN card upload fields start -->
                <form action="{{ route('student.uploadDocuments') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row mt-4">
                        <div class="col-xl-6">
                            {{-- Display Aadhaar Card --}}
                            @if (!empty($data['student']->aadhaarCard))
                            <p class="pera mb-6">
                                <img src="{{ env('APP_URL'). Storage::url('app/public/'.$data['student']->aadhaarCard->original) }}" alt="Aadhaar Card Image" style="max-width: 100%; height: 200px;">
                            </p>
                            @endif
                            <div class="form-group">
                                <label for="aadhaar_card">{{ ___('student.Aadhaar Card') }}</label>
                                <input type="file" class="form-control" id="aadhaar_card" name="aadhaar_card">
                            </div>
                        </div>
                        <div class="col-xl-6">
                            {{-- Display PAN Card --}}
                            @if (!empty($data['student']->panCard))
                            <p class="pera mb-6">
                                <img src="{{ env('APP_URL'). Storage::url('app/public/'.$data['student']->panCard->original) }}" alt="PAN Card Image" style="max-width: 100%; height: 200px">
                            </p>
                            @endif
                            <div class="form-group">
                                <label for="pan_card">{{ ___('student.PAN Card') }}</label>
                                <input type="file" class="form-control" id="pan_card" name="pan_card">
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">{{ ___('student.Upload Documents') }}</button>
                </form>
                <!-- Aadhaar and PAN card upload fields end -->
            </div>
        </div>
    </div>
</section>
<!-- End-of Profile -->
@endsection