<?php $__env->startSection('title'); ?>
<?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<div class="page-content">

    
    <?php echo $__env->make('backend.ui-components.breadcrumb', [
    'title' => @$data['title'],
    'routes' => [
    route('dashboard') => ___('common.Dashboard'),
    '#' => @$data['title'],
    ],

    'buttons' => 1,
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    

    <!--  table content start -->
    <div class="table-content table-basic ecommerce-components product-list">
        <div class="card">
            <div class="card-body">
                <!--  toolbar table start  -->
                <div class="table-toolbar d-flex flex-wrap gap-2 flex-column flex-xl-row justify-content-center justify-content-xxl-between align-content-center pb-3">
                    <form action="" method="get">
                        <div class="align-self-center">
                            <div class="d-flex flex-wrap gap-2 flex-column flex-lg-row justify-content-center align-content-center">
                                <!-- show per page -->
                                <?php echo $__env->make('backend.ui-components.per-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <!-- show per page end -->

                                <div class="align-self-center d-flex gap-2">
                                    <!-- search start -->
                                    <div class="align-self-center">
                                        <div class="search-box d-flex">
                                            <input class="form-control" placeholder="<?php echo e(___('common.search')); ?>" name="search" value="<?php echo e(@$_GET['search']); ?>" />
                                            <span class="icon"><i class="fa-solid fa-magnifying-glass"></i></span>
                                        </div>
                                    </div>
                                    <!-- search end -->

                                    <!-- dropdown action -->
                                    <div class="align-self-center">
                                        <div class="dropdown dropdown-action" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Filter">
                                            <button type="submit" class="btn-add">
                                                <span class="icon"><?php echo e(___('common.Filter')); ?></span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>


                    <!-- add btn start -->
                    <?php if(hasPermission('admin.stream_create')): ?>
                    <div class="align-self-center d-flex gap-2">
                        <!-- add btn -->
                        <div class="align-self-center">
                            <a href="<?php echo e(route('admin.stream.create')); ?>" role="button" class="btn-add" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Add">
                                <span><i class="fa-solid fa-plus"></i> </span>
                                <span class="d-none d-xl-inline"><?php echo e(___('common.add')); ?></span>
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>
                    <!-- add btn end -->
                </div>
                <!--toolbar table end -->
                <!--  table start -->
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead">
                            <!-- start table header from ui-helper function -->
                            <?php echo e(table_header('', $data['tableHeader'])); ?>

                            <!-- end table header from ui-helper function -->
                        </thead>
                        <tbody class="tbody">

                            <?php $__empty_1 = true; $__currentLoopData = $data['streams']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            
                            <tr>
                                <td><?php echo e(@$category->id); ?></td>
                                <td><?php echo e(Str::limit(@$category->name, 20)); ?></td>
                                <td>
                                    <?php echo e(statusBackend(@$category->status->class, $category->status->name)); ?>

                                </td>

                                <td class="create-date"><?php echo e(showDate(@$category->created_at)); ?></td>

                                <td class="action">
                                    <div class="dropdown dropdown-action">
                                        <button type="button" class="btn-dropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i class="fa-solid fa-ellipsis"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-end">

                                            <?php if(hasPermission('stream_update')): ?>
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e(route('admin.stream.edit', $category->id)); ?>"><span class="icon mr-12"><i class="fa-solid fa-pen-to-square"></i></span>
                                                    <?php echo e(___('common.edit')); ?></a>
                                            </li>
                                            <?php endif; ?>
                                            <?php if(hasPermission('stream_delete')): ?>
                                            <li>
                                                <a class="dropdown-item delete_data" href="javascript:void(0);" data-href="<?php echo e(route('admin.stream.delete', $category->id)); ?>">
                                                    <span class="icon mr-8"><i class="fa-solid fa-trash-can"></i></span>
                                                    <span><?php echo e(___('common.delete')); ?></span>
                                                </a>
                                            </li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <!-- empty table -->
                            <?php echo $__env->make('backend.ui-components.empty_table', [
                            'colspan' => '5',
                            'message' => ___(
                            'message.Please add a new entity or manage the data table to see the content here'),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <!-- empty table -->
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <!--  table end -->
                <!--  pagination start -->
                <?php echo $__env->make('backend.ui-components.pagination', ['data' => $data['streams']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!--  pagination end -->
            </div>
        </div>
    </div>
    <!--  table content end -->
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<?php echo $__env->make('backend.partials.delete-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Stream/Resources/views/index.blade.php ENDPATH**/ ?>