
<?php $__env->startSection('title', @$data['title']); ?>
<?php $__env->startSection('css'); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('updated_frontend/css/home/qa.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<section class="askSection">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="row">
                    <section class="que-wrap">
                        <div class="qna-title">
                            <h1>Ask & Answer:</h1>
                        </div>
                        <div class="block box">
                            <form action="<?php echo e(route('frontend.submit-question')); ?>" method="POST" id="askQuestionForm">
                                <?php echo csrf_field(); ?>
                                <div class="askQuestion">
                                    <input type="text" name="question" placeholder="type your Question">
                                    <!-- Button trigger modal -->
                                    <button type="button" class="Askque-btn" data-bs-toggle="modal" data-bs-target="#staticBackdrop">Post</button>
                                    <!-- Modal -->
                                    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h1 class="modal-title fs-5" id="staticBackdropLabel">hello</h1>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <!-- <div class="modal-body">
                                                    
                                                </div> -->
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" id="reply_from_expert" data-bs-dismiss="modal">Reply from Expert</button>
                                                    <p>OR</p>
                                                    <button class="btn btn-primary">else Continue</button>
                                                    <!-- <a href="">else Continue</a> -->
                                                    <!-- <a type="button" class="btn btn-primary">continue</a> -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </section>

                    <!-- Answer section -->
                    <section class="ans-wrap">
                        <div class="answerSection mb-3">
                            <h6>Questions & Answers for you</h6>
                        </div>

                        <?php if($data['questions']): ?>
                        <?php $__currentLoopData = $data['questions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="block box post-col">
                            <div>
                                <h6><?php echo e($question->question); ?></h6>
                            </div>
                            <form action="<?php echo e(route('frontend.submit-answer')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="replyAns">
                                    <div class="and-title">
                                        <textarea name="answer" id="" placeholder="type your answer here..."></textarea>
                                    </div>
                                    <div class="btns-box">
                                        <input type="hidden" name="question_id" value="<?php echo e($question->id); ?>">
                                        <button class="btnans" type="submit">Answer</button>
                                    </div>
                                </div>
                            </form>
                            <!-- <div class="replyAns">
                                <div class="and-title">
                                    <textarea name="" id="" placeholder="type your answer here..."></textarea>
                                </div>
                                <div class="btns-box">
                                    <a href="">Answer</a>
                                </div>
                            </div> -->
                            <!-- Post Answer -->
                            <?php if($question->answers): ?>
                            <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="answerPost mb-2">
                                <div class="postedProfile">
                                    <img src="<?php echo e(showImage(@$answer->user->image->original, 'default-1.jpeg')); ?>" alt="">
                                </div>
                                <div class="answer-info">
                                    <strong><?php echo e(optional($answer->user)->name); ?></strong>
                                    <p>Level-8</p>
                                    <p><?php echo e($answer->answer); ?></p>
                                    <div class="likeDislike">
                                        <a href="javascript:void(0);" class="like" data-id="<?php echo e($answer->id); ?>">
                                            <i class="fa-solid fa-thumbs-up"></i><span class="like-count"><?php echo e($answer->likes->count()); ?></span>
                                        </a>
                                        <a href="javascript:void(0);" class="dislike" data-id="<?php echo e($answer->id); ?>">
                                            <i class="fa-solid fa-thumbs-down"></i><span class="dislike-count"><?php echo e($answer->dislikes->count()); ?></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </section>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="askSectionBlog">
                    <h2>Blogs</h2>
                </div>
            </div>
        </div>

    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#reply_from_expert').click(function() {
            // alert('fdf')
            $('#askQuestionForm').submit();
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('.like').on('click', function() {
            var answerId = $(this).data('id');
            var likeCountElement = $(this).find('.like-count');
            var dislikeCountElement = $(this).siblings('.dislike').find('.dislike-count');

            $.ajax({
                url: '<?php echo e(url("question-answers/answer/like")); ?>/' + answerId,
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        likeCountElement.text(response.likes);
                        dislikeCountElement.text(response.dislikes);
                        Toast.fire({
                            icon: 'success',
                            title: 'Liked successfully'
                        });
                    }
                }
            });
        });

        $('.dislike').on('click', function() {
            var answerId = $(this).data('id');
            var likeCountElement = $(this).siblings('.like').find('.like-count');
            var dislikeCountElement = $(this).find('.dislike-count');

            $.ajax({
                url: '<?php echo e(url("question-answers/answer/dislike")); ?>/' + answerId,
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        likeCountElement.text(response.likes);
                        dislikeCountElement.text(response.dislikes);
                        Toast.fire({
                            icon: 'success',
                            title: 'Disliked successfully'
                        });

                    }
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/resources/views/frontend/page/question_and_answers.blade.php ENDPATH**/ ?>