<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <?php echo $__env->make('backend.ui-components.breadcrumb', [
            'title' => @$data['title'],
            'routes' => [
                route('dashboard') => ___('common.Dashboard'),
                '#' => @$data['title'],
            ],

            'buttons' => 1,
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        


        <!--  table content start -->
        <div class="table-content table-basic ecommerce-components product-list">
            <div class="card">
                <div class="card-body">
                    <!--  toolbar table start  -->
                    <div
                        class="table-toolbar d-flex flex-wrap gap-2 flex-column flex-xl-row justify-content-center justify-content-xxl-between align-content-center pb-3">

                        <form action="" method="get">
                            <div class="align-self-center">
                                <div
                                    class="d-flex flex-wrap gap-2 flex-column flex-lg-row justify-content-center align-content-center">
                                    <!-- show per page -->
                                    <?php echo $__env->make('backend.ui-components.per-page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <!-- show per page end -->

                                    <!-- start categories -->
                                    <div class="align-self-center">
                                        <div class="dropdown dropdown-designation custom-dropdown-select"
                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                            data-bs-title="<?php echo e(___('common.Category')); ?>">
                                            <select id="single" class="select2 form-control categories_select"
                                                name="category" data-href="<?php echo e(route('ajax-categories-list')); ?>">
                                                <option selected disabled><?php echo e(___('common.Select Category')); ?></option>
                                                <?php if(@$_GET['category']): ?>
                                                    <option value="<?php echo e($_GET['category']); ?>" selected>
                                                        <?php echo e(@$data['params']['category']); ?></option>
                                                <?php endif; ?>

                                            </select>
                                        </div>
                                    </div>
                                    <!-- end categories -->

                                    <!-- start categories -->
                                    <div class="align-self-center">
                                        <div class="dropdown dropdown-designation custom-dropdown-select"
                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                            data-bs-title="<?php echo e(___('common.Instructor')); ?>">
                                            <select class="form-control instructor_select w-100" name="instructor_id"
                                                data-href="<?php echo e(route('ajax-instructor-list')); ?>">
                                                <option selected disabled>
                                                    <?php echo e(___('common.Select Instructor')); ?></option>
                                                <?php if(@$_GET['instructor_id']): ?>
                                                    <option value="<?php echo e($_GET['instructor_id']); ?>" selected>
                                                        <?php echo e(@$data['params']['instructor']); ?></option>
                                                <?php endif; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- end categories -->

                                    <!-- start categories -->
                                    <div class="align-self-center">
                                        <div class="dropdown dropdown-designation custom-dropdown-select"
                                            data-bs-toggle="tooltip" data-bs-placement="top"
                                            data-bs-title="<?php echo e(___('ui_element.status')); ?>">
                                            <select class="form-control select2 w-100" name="status">
                                                <option selected disabled>
                                                    <?php echo e(___('common.Select Status')); ?></option>
                                                <?php if(@$_GET['status']): ?>
                                                    <option value="<?php echo e($_GET['status']); ?>" selected>
                                                        <?php echo e(@$data['params']['status']); ?></option>
                                                <?php endif; ?>
                                                <option value="1" <?php echo e(@$_GET['status'] == 1 ? 'selected' : ''); ?>>
                                                    <?php echo e(___('common.Active')); ?></option>
                                                <option value="3" <?php echo e(@$_GET['status'] == 3 ? 'selected' : ''); ?>>
                                                    <?php echo e(___('common.Pending')); ?></option>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- end categories -->

                                    <div class="align-self-center d-flex gap-2">
                                        <!-- search start -->
                                        <div class="align-self-center">
                                            <div class="search-box d-flex">
                                                <input class="form-control" placeholder="<?php echo e(___('common.search')); ?>"
                                                    name="search" value="<?php echo e(@$_GET['search']); ?>" />
                                                <span class="icon"><i class="fa-solid fa-magnifying-glass"></i></span>
                                            </div>
                                        </div>
                                        <!-- search end -->

                                        <!-- dropdown action -->
                                        <div class="align-self-center">
                                            <div class="dropdown dropdown-action" data-bs-toggle="tooltip"
                                                data-bs-placement="top" data-bs-title="Filter">
                                                <button type="submit" class="btn-add">
                                                    <span class="icon"><?php echo e(___('common.Filter')); ?> </span>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>

                        <!-- add btn start -->
                        <?php if(hasPermission('course_create')): ?>
                            <div class="align-self-center d-flex gap-2">
                                <!-- add btn -->
                                <div class="align-self-center">
                                    <a href="<?php echo e(route('course.create')); ?>" role="button" class="btn-add"
                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                        data-bs-title="<?php echo e(___('course.Add')); ?>">
                                        <span><i class="fa-solid fa-plus"></i> </span>
                                        <span class="d-none d-xl-inline"><?php echo e(___('common.add')); ?></span>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <!-- add btn end -->
                    </div>
                    <!--toolbar table end -->
                    <!--  table start -->
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead class="thead">
                                <!-- start table header from ui-helper function -->
                                <?php echo e(table_header('', $data['tableHeader'])); ?>

                                <!-- end table header from ui-helper function -->
                            </thead>
                            <tbody class="tbody">

                                <?php $__empty_1 = true; $__currentLoopData = $data['courses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(@$key + 1); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('frontend.courseDetails', @$course->slug)); ?>"
                                                class="text-primary">
                                                <?php echo e(Str::limit(@$course->title, 20)); ?>

                                            </a>
                                        </td>
                                        <td> <?php echo e(@$course->category->title); ?></td>
                                        <td>
                                            <?php echo e(___('common.Instructor')); ?> :
                                            <?php if(@$course->user && @$course->instructor): ?>
                                            <a href="<?php echo e(route('frontend.instructor.details', [$course->user->name, $course->user->id])); ?>"
                                                class="text-primary">
                                                <?php echo e(@$course->instructor->name); ?></a>
                                            <?php if(count(@$course->partnerInstructors()) > 0): ?>
                                                <br><?php echo e(___('course.Partner')); ?> :
                                                <?php echo e(partner_instructor_ui(@$course->partnerInstructors())); ?>

                                            <?php endif; ?>
                                            
                                            <?php endif; ?>
                                        </td>

                                        <td>
                                            <?php echo e(___('course.Total Section')); ?> :
                                            <?php echo e(numberFormat(@$course->sections->count())); ?>

                                            <br>
                                            <?php echo e(___('course.Total Lesson')); ?> :
                                            <?php echo e(numberFormat(@$course->lessons->count())); ?>

                                        </td>

                                        <td>
                                            <?php echo e(numberFormat(@$course->total_enroll)); ?>

                                        </td>

                                        <td>
                                            <?php if(@$course->is_free): ?>
                                                <?php echo e(___('common.Free')); ?>

                                            <?php else: ?>
                                                <?php echo e(showPrice(@$course->price)); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e(statusBackend(@$course->courseType->class, $course->courseType->name)); ?>

                                        </td>
                                        <td>
                                            <?php echo e(statusBackend(@$course->status->class, $course->status->name)); ?>

                                        </td>

                                        <td>
                                            <?php echo e(statusBackend(@$course->visibility->class, @$course->visibility->name)); ?>

                                        </td>

                                        <td class="action">
                                            <div class="dropdown dropdown-action">
                                                <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end">

                                                    <?php if(hasPermission('course_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('course.edit', [$course->id])); ?>"><span
                                                                    class="icon mr-12"><i
                                                                        class="fa-solid fa-pen-to-square"></i></span>
                                                                <?php echo e(___('common.edit')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('course_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('course.curriculum.index', [$course->id])); ?>"><span
                                                                    class="icon mr-12">
                                                                    <i class="fa-solid fa-file-lines"></i>
                                                                </span>
                                                                <?php echo e(___('common.Add Curriculum')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(module('LiveClass') && hasPermission('live_class_read')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('live_class.index', [$course->id])); ?>"><span
                                                                    class="icon mr-12">
                                                                    <i class="fa-solid fa-globe"></i>
                                                                </span>
                                                                <?php echo e(___('common.Add Live Class')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('course_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('course.assignment.index', [$course->id])); ?>"><span
                                                                    class="icon mr-12"><i
                                                                        class="fa-solid fa-file-pdf"></i></span>
                                                                <?php echo e(___('course.Add Assignment')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('course_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('course.notice-board.index', [$course->id])); ?>"><span
                                                                    class="icon mr-12"><i
                                                                        class="fa-solid fa-file"></i></span>
                                                                <?php echo e(___('course.Add NoticeBoard')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('course_read')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('course.details', [$course->id])); ?>"><span
                                                                    class="icon mr-12"><i
                                                                        class="fa-solid fa-eye"></i></span>
                                                                <?php echo e(___('common.Course Details')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('course_delete')): ?>
                                                        <li>
                                                            <a class="dropdown-item delete_data" href="javascript:void(0);"
                                                                data-href="<?php echo e(route('course.destroy', $course->id)); ?>">
                                                                <span class="icon mr-8"><i
                                                                        class="fa-solid fa-trash-can"></i></span>
                                                                <span><?php echo e(___('common.delete')); ?></span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <!-- empty table -->
                                    <?php echo $__env->make('backend.ui-components.empty_table', [
                                        'colspan' => '10',
                                        'message' => ___(
                                            'message.Please add a new entity or manage the data table to see the content here'),
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <!-- empty table -->
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->
                    <?php echo $__env->make('backend.ui-components.pagination', ['data' => $data['courses']], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Course/Resources/views/index.blade.php ENDPATH**/ ?>