<?php $__env->startSection('title', @$data['title'] ?? 'Blogs'); ?>
<?php $__env->startSection('content'); ?>

    <!--Bradcam S t a r t -->
    <?php echo $__env->make('frontend.partials.breadcrumb', [
        'breadcumb_title' => @$data['title'],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--End-of Bradcam  -->

    <div class="blog-details section-padding2">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-xl-9">

                    <!-- Share Post -->
                    <div class="d-flex justify-content-between align-items-start">
                        <!-- Blog Post user -->
                        <div class="user-profile2 mb-28">
                            <div class="user-img">
                                <img src="<?php echo e(showImage(@$data['blog']->user->image->original, 'default-1.jpeg')); ?>"
                                    class="img-cover" alt="<?php echo e(@$data['blog']->user->name); ?>">
                            </div>
                            <div class="user-cap">
                                <div class="cap">
                                    <h5><a href="#" class="title font-600"> <?php echo e(@$data['blog']->user->name); ?></a> </h5>
                                    <p class="pera"><?php echo e(@$data['blog']->created_at->diffForHumans()); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="blog-header text-center mb-40">
                        <h2 class="blog-title font-700"><?php echo e(@$data['blog']->title); ?></h2>
                    </div>

                    <!-- Single -->
                    <div class="single-description">
                        <p><?php echo @$data['blog']->description; ?></p>
                    </div>

                </div>
                <div class="col-xxl-4 col-xl-4 col-lg-5 col-md-6">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="ot-card">
                                <!-- Title -->
                                <div class="section-tittle-four mb-20">
                                    <h5 class="title text-capitalize font-600"><?php echo e(___('frontend.Latest Blogs')); ?></h5>
                                </div>

                                <?php if(!empty($data['latest_blogs'])): ?>
                                    <?php $__currentLoopData = $data['latest_blogs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest_blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!-- Single -->
                                        <div class="single-blogs single-blogs2 radius-6 white-bg mb-10">
                                            <div class="blog-content-box d-flex align-items-center">
                                                <div class="blog-img imgEffect radius-4">
                                                    <a href="<?php echo e(route('blog_details', $latest_blog->id)); ?>"><img
                                                            src="<?php echo e(showImage(@$latest_blog->iconImage->paths['220x300'], 'default-1.jpeg')); ?>"
                                                            class="img-cover" alt="img"></a>
                                                </div>
                                                <div class="blog-content">
                                                    <div class="capt">
                                                        <h3><a href="<?php echo e(route('blog_details', $latest_blog->id)); ?>"
                                                                class="title colorEffect font-600 line-clamp-2"><?php echo e(Str::limit(@$latest_blog->title, 60)); ?></a>
                                                        </h3>
                                                        <p class="pera line-clamp-1"><?php echo e(showDate(@$latest_blog->created_at)); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Single -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </section>
    <!-- End-of Blog -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/resources/views/frontend/blog/details.blade.php ENDPATH**/ ?>