<?php $__env->startSection('title', @$data['title']); ?>
<?php $__env->startSection('content'); ?>
<!-- Dashboard Card S t a r t -->
<div class="dashboared-card mb-40">
    <div class="row g-24">
        <div class="col-xl-4 col-sm-6">
            <div class="single-dashboard-card single-dashboard-card2 carts-bg-one h-calc d-flex align-items-center">
                <div class="icon">
                    <i class="ri-user-3-fill"></i>
                </div>
                <div class="cat-caption">
                    <p class="pera font-600"><?php echo e(___('instructor.Total Instructor')); ?></p>
                    <!-- Counter -->
                    <div class="single-counter mb-15">
                        <p class="currency">
                            <?php echo e(shorten_number(@$data['total_instructor'])); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6">
            <div class="single-dashboard-card single-dashboard-card2 carts-bg-two h-calc d-flex align-items-center">
                <div class="icon">
                    <i class="ri-user-unfollow-fill"></i>
                </div>
                <div class="cat-caption">
                    <p class="pera text-16 font-600"><?php echo e(___('instructor.Pending Instructor')); ?></p>
                    <!-- Counter -->
                    <div class="single-counter mb-15">
                        <p class="currency">
                            <?php echo e(shorten_number($data['instructor_pending'])); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-sm-6">
            <div class="single-dashboard-card single-dashboard-card2 carts-bg-four h-calc d-flex align-items-center">
                <div class="icon">
                    <i class="ri-user-follow-fill"></i>
                </div>
                <div class="cat-caption">
                    <p class="pera text-16 font-600"><?php echo e(___('instructor.Approved Instructor')); ?></p>
                    <!-- Counter -->
                    <div class="single-counter mb-15">
                        <p class="currency">
                            <?php echo e(shorten_number($data['instructor_approved'])); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End-of card -->
<!-- instructor Courses activity Start -->
<section class="instructor-courses-activity">
    <div class="row">
        <!-- Section Tittle -->
        <div class="col-xl-12">
            <div class="section-tittle-two d-flex align-items-center justify-content-between flex-wrap">
                <h2 class="title font-600 mb-20"><?php echo e($data['title']); ?></h2>
                <div class="right d-flex flex-wrap justify-content-between">
                    <!-- Search Box -->
                    <form action="" class="search-box-style mb-20 mr-10">
                        <div class="responsive-search-box">
                            <input class="ot-search " type="text" name="search"
                                placeholder="<?php echo e(___('placeholder.Search Instructor')); ?>" value="<?php echo e(@$_GET['search']); ?>">
                            <!-- icon -->
                            <div class="search-icon">
                                <i class="ri-search-line"></i>
                            </div>
                            <!-- Button -->
                            <button class="search-btn">
                                <?php echo e(___('frontend.Search')); ?>

                            </button>
                        </div>
                    </form>
                    <!-- /End -->
                    <div class="search-tab ">
                        <a class="btn-primary-fill main-modal-open-new" data-url="<?php echo e(route('organization.instructor.add')); ?>">
                            <i class="ri-add-line"></i> <?php echo e(___('organization.Add New Instructor')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="activity-table">
                <table class="table-responsive">
                    <thead>
                        <tr>
                            <th><?php echo e(___('instructorCommon.ID')); ?></th>
                            <th><?php echo e(___('instructor.Name')); ?></th>
                            <th><?php echo e(___('instructorCommon.Course')); ?></th>
                            <th><?php echo e(___('instructor.Sales')); ?></th>
                            <th><?php echo e(___('instructorCommon.Income')); ?></th>
                            <th><?php echo e(___('instructorCommon.Balance')); ?></th>
                            <th><?php echo e(___('instructorCommon.Status')); ?></th>
                            <th><?php echo e(___('instructorCommon.Created_at')); ?></th>
                            <th><?php echo e(___('instructorCommon.Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $data['instructors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td> <?php echo e($loop->iteration); ?></td>
                            <td><?php echo e(Str::limit(@$instructor->user->name, 20)); ?></td>
                            <td> <?php echo e(@$instructor->courses->count()); ?></td>
                            <td> <?php echo e(@$instructor->enroll->count()); ?></td>
                            <td><?php echo e(showPrice(@$instructor->earnings)); ?></td>
                            <td><?php echo e(showPrice(@$instructor->balance)); ?></td>
                            <td>
                                <?php if(@$instructor->user->userStatus->name === "Approve"): ?>
                                <span class="status-success">
                                    <?php echo e(___('instructorCommon.Approve')); ?>

                                </span>
                                <?php elseif(@$instructor->user->userStatus->name === "Suspended"): ?>
                                <span class="status-warning">
                                    <?php echo e(___('instructorCommon.Suspend')); ?>

                                </span>
                                <?php else: ?>
                                <span class="status-pending">
                                    <?php echo e(___('instructorCommon.Pending')); ?>

                                </span>
                                <?php endif; ?>
                            </td>
                            <td class="create-date"><?php echo e(showDate(@$instructor->created_at)); ?></td>
                            <td>

                                <a href="<?php echo e(route('organization.instructor.edit', [encryptFunction($instructor->user->id), 'general'])); ?>" class="action-success">
                                    <i class="ri-pencil-line"></i>
                                </a>
                                <?php if(@$instructor->user->userStatus->name === "Approve"): ?>
                                <a href="javascript:;" class="action-tertiary" onclick="suspendFunction(`<?php echo e(route('organization.instructor.suspend', $instructor->id)); ?>`, `<?php echo e(___('organization.Yes_suspend_it')); ?>`)">
                                    <i class="ri-admin-line"></i>
                                </a>
                                <?php else: ?>
                                <a href="javascript:;" class="action-success" onclick="approveFunction(`<?php echo e(route('organization.instructor.approve', $instructor->id)); ?>`, `<?php echo e(___('organization.Yes_approve_it')); ?>`)">
                                    <i class="ri-user-follow-line"></i>
                                </a>
                                <?php endif; ?>
                                <a href="javascript:;" class="action-danger" onclick="deleteFunction(`<?php echo e(route('organization.instructor.delete', $instructor->id)); ?>`)">
                                    <i class="ri-delete-bin-line"></i>
                                </a>

                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9">
                                <div class="alert alert-warning">
                                    <?php echo e(___('instructor.No Instructor Found')); ?>

                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
<!-- End-of courses activity  -->
<!--  pagination start -->
<?php echo @$data['instructors']->links('frontend.partials.pagination-count'); ?>

<!--  pagination end -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('organization::panel.organization.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/eduroutez.nexprism.com/Modules/Organization/Resources/views/panel/organization/instructor/instructor_list.blade.php ENDPATH**/ ?>